/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.collect;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Preconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.CollectPreconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ObjectArrays;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Platform;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public abstract class ImmutableCollection<E>
extends AbstractCollection<E>
implements Serializable {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    ImmutableCollection() {
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public final Object[] toArray() {
        return this.toArray(EMPTY_ARRAY);
    }

    @Override
    public final <T> T[] toArray(T[] TArray) {
        Preconditions.checkNotNull(TArray);
        int n = this.size();
        if (TArray.length < n) {
            Object[] objectArray = this.internalArray();
            if (objectArray != null) {
                return Platform.copy(objectArray, this.internalArrayStart(), this.internalArrayEnd(), TArray);
            }
            TArray = ObjectArrays.newArray(TArray, n);
        } else if (TArray.length > n) {
            TArray[n] = null;
        }
        this.copyIntoArray(TArray, 0);
        return TArray;
    }

    Object[] internalArray() {
        return null;
    }

    int internalArrayStart() {
        throw new UnsupportedOperationException();
    }

    int internalArrayEnd() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract boolean contains(Object var1);

    @Override
    public final boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public ImmutableList<E> asList() {
        return this.isEmpty() ? ImmutableList.of() : ImmutableList.asImmutableList(this.toArray());
    }

    abstract boolean isPartialView();

    int copyIntoArray(Object[] objectArray, int n) {
        for (Object e : this) {
            objectArray[n++] = e;
        }
        return n;
    }

    static abstract class ArrayBasedBuilder<E>
    extends Builder<E> {
        Object[] contents;
        int size;
        boolean forceCopy;

        ArrayBasedBuilder(int n) {
            CollectPreconditions.checkNonnegative(n, "initialCapacity");
            this.contents = new Object[n];
            this.size = 0;
        }

        private void getReadyToExpandTo(int n) {
            if (this.contents.length < n) {
                this.contents = Arrays.copyOf(this.contents, ArrayBasedBuilder.expandedCapacity(this.contents.length, n));
                this.forceCopy = false;
            } else if (this.forceCopy) {
                this.contents = (Object[])this.contents.clone();
                this.forceCopy = false;
            }
        }

        @Override
        public ArrayBasedBuilder<E> add(E e) {
            Preconditions.checkNotNull(e);
            this.getReadyToExpandTo(this.size + 1);
            this.contents[this.size++] = e;
            return this;
        }
    }

    public static abstract class Builder<E> {
        static int expandedCapacity(int n, int n2) {
            if (n2 < 0) {
                throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
            }
            int n3 = n + (n >> 1) + 1;
            if (n3 < n2) {
                n3 = Integer.highestOneBit(n2 - 1) << 1;
            }
            if (n3 < 0) {
                n3 = Integer.MAX_VALUE;
            }
            return n3;
        }

        Builder() {
        }

        public abstract Builder<E> add(E var1);

        public Builder<E> addAll(Iterator<? extends E> iterator) {
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
            return this;
        }
    }
}

