/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.collect;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.CollectPreconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableCollection;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSet;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Maps;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Ordering;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.RegularImmutableMap;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;

public abstract class ImmutableMap<K, V>
implements Serializable,
Map<K, V> {
    static final Map.Entry<?, ?>[] EMPTY_ENTRY_ARRAY = new Map.Entry[0];
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSet<K> keySet;
    private transient ImmutableCollection<V> values;

    public static <K, V> ImmutableMap<K, V> of() {
        return RegularImmutableMap.EMPTY;
    }

    public static <K, V> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        ImmutableMap immutableMap;
        if (map instanceof ImmutableMap && !(map instanceof SortedMap) && !(immutableMap = (ImmutableMap)map).isPartialView()) {
            return immutableMap;
        }
        return ImmutableMap.copyOf(map.entrySet());
    }

    public static <K, V> ImmutableMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
        int n = iterable instanceof Collection ? ((Collection)iterable).size() : 4;
        Builder builder = new Builder(n);
        builder.putAll(iterable);
        return builder.build();
    }

    ImmutableMap() {
    }

    @Override
    public final V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        return ((ImmutableCollection)this.values()).contains(object);
    }

    @Override
    public abstract V get(Object var1);

    @Override
    public final V getOrDefault(Object object, V v) {
        V v2 = this.get(object);
        return v2 != null ? v2 : v;
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        ImmutableSet<Map.Entry<K, V>> immutableSet = this.entrySet;
        return immutableSet == null ? (this.entrySet = this.createEntrySet()) : immutableSet;
    }

    abstract ImmutableSet<Map.Entry<K, V>> createEntrySet();

    @Override
    public ImmutableSet<K> keySet() {
        ImmutableSet<K> immutableSet = this.keySet;
        return immutableSet == null ? (this.keySet = this.createKeySet()) : immutableSet;
    }

    abstract ImmutableSet<K> createKeySet();

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> immutableCollection = this.values;
        return immutableCollection == null ? (this.values = this.createValues()) : immutableCollection;
    }

    abstract ImmutableCollection<V> createValues();

    @Override
    public boolean equals(Object object) {
        return Maps.equalsImpl(this, object);
    }

    abstract boolean isPartialView();

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this.entrySet());
    }

    boolean isHashCodeFast() {
        return false;
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }

    public static class Builder<K, V> {
        Comparator<? super V> valueComparator;
        Object[] alternatingKeysAndValues;
        int size;
        boolean entriesUsed;

        public Builder() {
            this(4);
        }

        Builder(int n) {
            this.alternatingKeysAndValues = new Object[2 * n];
            this.size = 0;
            this.entriesUsed = false;
        }

        private void ensureCapacity(int n) {
            if (n * 2 > this.alternatingKeysAndValues.length) {
                this.alternatingKeysAndValues = Arrays.copyOf(this.alternatingKeysAndValues, ImmutableCollection.Builder.expandedCapacity(this.alternatingKeysAndValues.length, n * 2));
                this.entriesUsed = false;
            }
        }

        public Builder<K, V> put(K k, V v) {
            this.ensureCapacity(this.size + 1);
            CollectPreconditions.checkEntryNotNull(k, v);
            this.alternatingKeysAndValues[2 * this.size] = k;
            this.alternatingKeysAndValues[2 * this.size + 1] = v;
            ++this.size;
            return this;
        }

        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            return this.put(entry.getKey(), entry.getValue());
        }

        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            if (iterable instanceof Collection) {
                this.ensureCapacity(this.size + ((Collection)iterable).size());
            }
            for (Map.Entry<K, V> entry : iterable) {
                this.put(entry);
            }
            return this;
        }

        public ImmutableMap<K, V> build() {
            this.sortEntries();
            this.entriesUsed = true;
            return RegularImmutableMap.create(this.size, this.alternatingKeysAndValues);
        }

        void sortEntries() {
            if (this.valueComparator != null) {
                int n;
                if (this.entriesUsed) {
                    this.alternatingKeysAndValues = Arrays.copyOf(this.alternatingKeysAndValues, 2 * this.size);
                }
                Map.Entry[] entryArray = new Map.Entry[this.size];
                for (n = 0; n < this.size; ++n) {
                    entryArray[n] = new AbstractMap.SimpleImmutableEntry<Object, Object>(this.alternatingKeysAndValues[2 * n], this.alternatingKeysAndValues[2 * n + 1]);
                }
                Arrays.sort(entryArray, 0, this.size, Ordering.from(this.valueComparator).onResultOf(Maps.valueFunction()));
                for (n = 0; n < this.size; ++n) {
                    this.alternatingKeysAndValues[2 * n] = entryArray[n].getKey();
                    this.alternatingKeysAndValues[2 * n + 1] = entryArray[n].getValue();
                }
            }
        }
    }
}

