/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSet;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.HiddenApiRestriction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference.BaseFieldReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.AnnotationsDirectory;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.EncodedArrayItemIterator;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Field;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;
import java.util.EnumSet;
import java.util.Set;

public class DexBackedField
extends BaseFieldReference
implements Field {
    public final DexBackedDexFile dexFile;
    public final ClassDef classDef;
    public final int accessFlags;
    public final EncodedValue initialValue;
    public final int annotationSetOffset;
    public final int fieldIndex;
    private final int startOffset;
    private final int initialValueOffset;
    private final int hiddenApiRestrictions;
    private int fieldIdItemOffset;

    public DexBackedField(DexBackedDexFile dexBackedDexFile, DexReader dexReader, DexBackedClassDef dexBackedClassDef, int n, EncodedArrayItemIterator encodedArrayItemIterator, AnnotationsDirectory.AnnotationIterator annotationIterator, int n2) {
        this.dexFile = dexBackedDexFile;
        this.classDef = dexBackedClassDef;
        this.startOffset = dexReader.getOffset();
        int n3 = dexReader.readLargeUleb128();
        this.fieldIndex = n3 + n;
        this.accessFlags = dexReader.readSmallUleb128();
        this.annotationSetOffset = annotationIterator.seekTo(this.fieldIndex);
        this.initialValueOffset = encodedArrayItemIterator.getReaderOffset();
        this.initialValue = encodedArrayItemIterator.getNextOrNull();
        this.hiddenApiRestrictions = n2;
    }

    public DexBackedField(DexBackedDexFile dexBackedDexFile, DexReader dexReader, DexBackedClassDef dexBackedClassDef, int n, AnnotationsDirectory.AnnotationIterator annotationIterator, int n2) {
        this.dexFile = dexBackedDexFile;
        this.classDef = dexBackedClassDef;
        this.startOffset = dexReader.getOffset();
        int n3 = dexReader.readLargeUleb128();
        this.fieldIndex = n3 + n;
        this.accessFlags = dexReader.readSmallUleb128();
        this.annotationSetOffset = annotationIterator.seekTo(this.fieldIndex);
        this.initialValueOffset = 0;
        this.initialValue = null;
        this.hiddenApiRestrictions = n2;
    }

    @Override
    public String getName() {
        return (String)this.dexFile.getStringSection().get(this.dexFile.getBuffer().readSmallUint(this.getFieldIdItemOffset() + 4));
    }

    @Override
    public String getType() {
        return (String)this.dexFile.getTypeSection().get(this.dexFile.getBuffer().readUshort(this.getFieldIdItemOffset() + 2));
    }

    @Override
    public String getDefiningClass() {
        return this.classDef.getType();
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public EncodedValue getInitialValue() {
        return this.initialValue;
    }

    public Set<? extends DexBackedAnnotation> getAnnotations() {
        return AnnotationsDirectory.getAnnotations(this.dexFile, this.annotationSetOffset);
    }

    @Override
    public Set<HiddenApiRestriction> getHiddenApiRestrictions() {
        if (this.hiddenApiRestrictions == 7) {
            return ImmutableSet.of();
        }
        return EnumSet.copyOf(HiddenApiRestriction.getAllFlags(this.hiddenApiRestrictions));
    }

    public static void skipFields(DexReader dexReader, int n) {
        for (int i = 0; i < n; ++i) {
            dexReader.skipUleb128();
            dexReader.skipUleb128();
        }
    }

    private int getFieldIdItemOffset() {
        if (this.fieldIdItemOffset == 0) {
            this.fieldIdItemOffset = this.dexFile.getFieldSection().getOffset(this.fieldIndex);
        }
        return this.fieldIdItemOffset;
    }
}

