/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.util;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Function;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Predicate;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.FluentIterable;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.value.BaseArrayEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Field;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.ArrayEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableEncodedValueFactory;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.EncodedValueUtils;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.AbstractForwardSequentialList;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.CollectionUtils;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class StaticInitializerUtil {
    private static final Predicate<Field> HAS_INITIALIZER = new Predicate<Field>(){

        @Override
        public boolean apply(Field field) {
            EncodedValue encodedValue = field.getInitialValue();
            return encodedValue != null && !EncodedValueUtils.isDefaultValue(encodedValue);
        }
    };
    private static final Function<Field, EncodedValue> GET_INITIAL_VALUE = new Function<Field, EncodedValue>(){

        @Override
        public EncodedValue apply(Field field) {
            EncodedValue encodedValue = field.getInitialValue();
            if (encodedValue == null) {
                return ImmutableEncodedValueFactory.defaultValueForType(field.getType());
            }
            return encodedValue;
        }
    };

    public static ArrayEncodedValue getStaticInitializers(final SortedSet<? extends Field> sortedSet) {
        final int n = CollectionUtils.lastIndexOf(sortedSet, HAS_INITIALIZER);
        if (n > -1) {
            return new BaseArrayEncodedValue(){

                @Override
                public List<? extends EncodedValue> getValue() {
                    return new AbstractForwardSequentialList<EncodedValue>(){

                        @Override
                        public Iterator<EncodedValue> iterator() {
                            return FluentIterable.from(sortedSet).limit(n + 1).transform(GET_INITIAL_VALUE).iterator();
                        }

                        @Override
                        public int size() {
                            return n + 1;
                        }
                    };
                }
            };
        }
        return null;
    }
}

