/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.client5.http.protocol;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiremock.org.apache.hc.client5.http.RouteInfo;
import wiremock.org.apache.hc.client5.http.auth.AuthCache;
import wiremock.org.apache.hc.client5.http.auth.AuthExchange;
import wiremock.org.apache.hc.client5.http.auth.AuthScheme;
import wiremock.org.apache.hc.client5.http.auth.CredentialsProvider;
import wiremock.org.apache.hc.client5.http.protocol.HttpClientContext;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.EntityDetails;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpHost;
import wiremock.org.apache.hc.core5.http.HttpRequest;
import wiremock.org.apache.hc.core5.http.HttpRequestInterceptor;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.net.URIAuthority;
import wiremock.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestAuthCache
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestAuthCache.class);

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        AuthScheme authScheme;
        AuthExchange proxyAuthExchange;
        HttpHost proxy;
        AuthScheme authScheme2;
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        String exchangeId = clientContext.getExchangeId();
        AuthCache authCache = clientContext.getAuthCache();
        if (authCache == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Auth cache not set in the context", (Object)exchangeId);
            }
            return;
        }
        CredentialsProvider credsProvider = clientContext.getCredentialsProvider();
        if (credsProvider == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Credentials provider not set in the context", (Object)exchangeId);
            }
            return;
        }
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Route info not set in the context", (Object)exchangeId);
            }
            return;
        }
        URIAuthority authority = request.getAuthority();
        HttpHost target = authority != null ? new HttpHost(request.getScheme(), authority.getHostName(), authority.getPort() >= 0 ? authority.getPort() : route.getTargetHost().getPort()) : route.getTargetHost();
        AuthExchange targetAuthExchange = clientContext.getAuthExchange(target);
        if (targetAuthExchange.getState() == AuthExchange.State.UNCHALLENGED && (authScheme2 = authCache.get(target)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Re-using cached '{}' auth scheme for {}", exchangeId, authScheme2.getName(), target);
            }
            targetAuthExchange.select(authScheme2);
        }
        if ((proxy = route.getProxyHost()) != null && (proxyAuthExchange = clientContext.getAuthExchange(proxy)).getState() == AuthExchange.State.UNCHALLENGED && (authScheme = authCache.get(proxy)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Re-using cached '{}' auth scheme for {}", exchangeId, authScheme.getName(), proxy);
            }
            proxyAuthExchange.select(authScheme);
        }
    }
}

