/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.jayway.jsonpath.spi.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.ObjectMapper;
import wiremock.com.fasterxml.jackson.databind.node.ArrayNode;
import wiremock.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import wiremock.com.fasterxml.jackson.databind.node.ObjectNode;
import wiremock.com.fasterxml.jackson.databind.node.TextNode;
import wiremock.com.jayway.jsonpath.InvalidJsonException;
import wiremock.com.jayway.jsonpath.JsonPathException;
import wiremock.com.jayway.jsonpath.spi.json.AbstractJsonProvider;

public class JacksonJsonNodeJsonProvider
extends AbstractJsonProvider {
    private static final ObjectMapper defaultObjectMapper = new ObjectMapper();
    protected ObjectMapper objectMapper;

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public JacksonJsonNodeJsonProvider() {
        this(defaultObjectMapper);
    }

    public JacksonJsonNodeJsonProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public Object parse(String json) throws InvalidJsonException {
        try {
            return this.objectMapper.readTree(json);
        }
        catch (IOException e) {
            throw new InvalidJsonException(e, json);
        }
    }

    @Override
    public Object parse(byte[] json) throws InvalidJsonException {
        try {
            return this.objectMapper.readTree(json);
        }
        catch (IOException e) {
            throw new InvalidJsonException(e, new String(json, StandardCharsets.UTF_8));
        }
    }

    @Override
    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        try {
            return this.objectMapper.readTree(new InputStreamReader(jsonStream, charset));
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        if (!(obj instanceof JsonNode)) {
            throw new JsonPathException("Not a JSON Node");
        }
        return obj.toString();
    }

    @Override
    public Object createArray() {
        return JsonNodeFactory.instance.arrayNode();
    }

    @Override
    public Object createMap() {
        return JsonNodeFactory.instance.objectNode();
    }

    @Override
    public Object unwrap(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof JsonNode)) {
            return o;
        }
        JsonNode e = (JsonNode)o;
        if (e.isValueNode()) {
            if (e.isTextual()) {
                return e.asText();
            }
            if (e.isBoolean()) {
                return e.asBoolean();
            }
            if (e.isInt()) {
                return e.asInt();
            }
            if (e.isLong()) {
                return e.asLong();
            }
            if (e.isBigInteger()) {
                return e.bigIntegerValue();
            }
            if (e.isDouble()) {
                return e.doubleValue();
            }
            if (e.isFloat()) {
                return Float.valueOf(e.floatValue());
            }
            if (e.isBigDecimal()) {
                return e.decimalValue();
            }
            if (e.isNull()) {
                return null;
            }
        }
        return o;
    }

    @Override
    public boolean isArray(Object obj) {
        return obj instanceof ArrayNode || obj instanceof List;
    }

    @Override
    public Object getArrayIndex(Object obj, int idx) {
        return this.toJsonArray(obj).get(idx);
    }

    @Override
    public void setArrayIndex(Object array, int index, Object newValue) {
        if (!this.isArray(array)) {
            throw new UnsupportedOperationException();
        }
        ArrayNode arrayNode = this.toJsonArray(array);
        if (index == arrayNode.size()) {
            arrayNode.add(this.createJsonElement(newValue));
        } else {
            arrayNode.set(index, this.createJsonElement(newValue));
        }
    }

    @Override
    public Object getMapValue(Object obj, String key) {
        ObjectNode jsonObject = this.toJsonObject(obj);
        JsonNode o = jsonObject.get(key);
        if (!jsonObject.has(key)) {
            return UNDEFINED;
        }
        return this.unwrap(o);
    }

    @Override
    public void setProperty(Object obj, Object key, Object value) {
        if (this.isMap(obj)) {
            this.setValueInObjectNode((ObjectNode)obj, key, value);
        } else {
            ArrayNode array;
            int index = key != null ? (key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString())) : array.size();
            if (index == (array = (ArrayNode)obj).size()) {
                array.add(this.createJsonElement(value));
            } else {
                array.set(index, this.createJsonElement(value));
            }
        }
    }

    @Override
    public void removeProperty(Object obj, Object key) {
        if (this.isMap(obj)) {
            this.toJsonObject(obj).remove(key.toString());
        } else {
            ArrayNode array = this.toJsonArray(obj);
            int index = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
            array.remove(index);
        }
    }

    @Override
    public boolean isMap(Object obj) {
        return obj instanceof ObjectNode;
    }

    @Override
    public Collection<String> getPropertyKeys(Object obj) {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator<String> iter = this.toJsonObject(obj).fieldNames();
        while (iter.hasNext()) {
            keys.add(iter.next());
        }
        return keys;
    }

    @Override
    public int length(Object obj) {
        if (this.isArray(obj)) {
            return this.toJsonArray(obj).size();
        }
        if (this.isMap(obj)) {
            return this.toJsonObject(obj).size();
        }
        if (obj instanceof TextNode) {
            TextNode element = (TextNode)obj;
            return element.size();
        }
        throw new JsonPathException("length operation can not applied to " + (obj != null ? obj.getClass().getName() : "null"));
    }

    @Override
    public Iterable<?> toIterable(Object obj) {
        ArrayNode arr = this.toJsonArray(obj);
        ArrayList<Object> values = new ArrayList<Object>(arr.size());
        for (JsonNode o : arr) {
            values.add(this.unwrap(o));
        }
        return values;
    }

    private JsonNode createJsonElement(Object o) {
        if (o != null) {
            if (o instanceof JsonNode) {
                return (JsonNode)o;
            }
            return this.objectMapper.valueToTree(o);
        }
        return null;
    }

    private ArrayNode toJsonArray(Object o) {
        return (ArrayNode)o;
    }

    private ObjectNode toJsonObject(Object o) {
        return (ObjectNode)o;
    }

    private void setValueInObjectNode(ObjectNode objectNode, Object key, Object value) {
        if (value instanceof JsonNode) {
            objectNode.set(key.toString(), (JsonNode)value);
        } else if (value instanceof String) {
            objectNode.put(key.toString(), (String)value);
        } else if (value instanceof Integer) {
            objectNode.put(key.toString(), (Integer)value);
        } else if (value instanceof Long) {
            objectNode.put(key.toString(), (Long)value);
        } else if (value instanceof Short) {
            objectNode.put(key.toString(), (Short)value);
        } else if (value instanceof BigInteger) {
            objectNode.put(key.toString(), (BigInteger)value);
        } else if (value instanceof Double) {
            objectNode.put(key.toString(), (Double)value);
        } else if (value instanceof Float) {
            objectNode.put(key.toString(), (Float)value);
        } else if (value instanceof BigDecimal) {
            objectNode.put(key.toString(), (BigDecimal)value);
        } else if (value instanceof Boolean) {
            objectNode.put(key.toString(), (Boolean)value);
        } else if (value instanceof byte[]) {
            objectNode.put(key.toString(), (byte[])value);
        } else if (value == null) {
            objectNode.set(key.toString(), null);
        } else {
            objectNode.set(key.toString(), this.createJsonElement(value));
        }
    }
}

