/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class UrlEncodingHelper
implements Helper<Object> {
    public Object apply(Object context, Options options) throws IOException {
        String encoding;
        Object encodingObj = options.hash.get("encoding");
        String string = encoding = encodingObj != null ? encodingObj.toString() : "utf-8";
        if (Boolean.TRUE.equals(options.hash.get("decode"))) {
            return this.decode(context.toString(), encoding);
        }
        return this.encode(context.toString(), encoding);
    }

    private String encode(String value, String encoding) throws IOException {
        try {
            return URLEncoder.encode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e);
        }
    }

    private String decode(String value, String encoding) throws IOException {
        try {
            return URLDecoder.decode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e);
        }
    }
}

