/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import wiremock.org.eclipse.jetty.client.HttpClient;
import wiremock.org.eclipse.jetty.client.HttpClientTransport;
import wiremock.org.eclipse.jetty.client.HttpDestination;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.SelectChannelEndPoint;
import wiremock.org.eclipse.jetty.io.SelectorManager;
import wiremock.org.eclipse.jetty.util.Promise;
import wiremock.org.eclipse.jetty.util.component.ContainerLifeCycle;
import wiremock.org.eclipse.jetty.util.log.Log;
import wiremock.org.eclipse.jetty.util.log.Logger;

public abstract class AbstractHttpClientTransport
extends ContainerLifeCycle
implements HttpClientTransport {
    protected static final Logger LOG = Log.getLogger(HttpClientTransport.class);
    private final int selectors;
    private volatile HttpClient client;
    private volatile SelectorManager selectorManager;

    protected AbstractHttpClientTransport(int selectors) {
        this.selectors = selectors;
    }

    protected HttpClient getHttpClient() {
        return this.client;
    }

    @Override
    public void setHttpClient(HttpClient client) {
        this.client = client;
    }

    @Override
    protected void doStart() throws Exception {
        this.selectorManager = this.newSelectorManager(this.client);
        this.selectorManager.setConnectTimeout(this.client.getConnectTimeout());
        this.addBean(this.selectorManager);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.selectorManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(SocketAddress address, Map<String, Object> context) {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            HttpDestination destination = (HttpDestination)context.get("http.destination");
            HttpClient client = destination.getHttpClient();
            SocketAddress bindAddress = client.getBindAddress();
            if (bindAddress != null) {
                channel.bind(bindAddress);
            }
            this.configure(client, channel);
            context.put("ssl.peer.host", destination.getHost());
            context.put("ssl.peer.port", destination.getPort());
            if (client.isConnectBlocking()) {
                channel.socket().connect(address, (int)client.getConnectTimeout());
                channel.configureBlocking(false);
                this.selectorManager.accept(channel, context);
            } else {
                channel.configureBlocking(false);
                if (channel.connect(address)) {
                    this.selectorManager.accept(channel, context);
                } else {
                    this.selectorManager.connect(channel, context);
                }
            }
        }
        catch (Throwable x) {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException xx) {
                LOG.ignore(xx);
            }
            finally {
                this.connectFailed(context, x);
            }
        }
    }

    protected void connectFailed(Map<String, Object> context, Throwable x) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not connect to {}", context.get("http.destination"));
        }
        Promise promise = (Promise)context.get("http.connection.promise");
        promise.failed(x);
    }

    protected void configure(HttpClient client, SocketChannel channel) throws IOException {
        channel.socket().setTcpNoDelay(client.isTCPNoDelay());
    }

    protected SelectorManager newSelectorManager(HttpClient client) {
        return new ClientSelectorManager(client, this.selectors);
    }

    protected class ClientSelectorManager
    extends SelectorManager {
        private final HttpClient client;

        protected ClientSelectorManager(HttpClient client, int selectors) {
            super(client.getExecutor(), client.getScheduler(), selectors);
            this.client = client;
        }

        @Override
        protected EndPoint newEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selector, SelectionKey key) {
            return new SelectChannelEndPoint(channel, selector, key, this.getScheduler(), this.client.getIdleTimeout());
        }

        @Override
        public Connection newConnection(SocketChannel channel, EndPoint endPoint, Object attachment) throws IOException {
            Map context = (Map)attachment;
            HttpDestination destination = (HttpDestination)context.get("http.destination");
            return destination.getClientConnectionFactory().newConnection(endPoint, context);
        }

        @Override
        protected void connectionFailed(SocketChannel channel, Throwable x, Object attachment) {
            Map context = (Map)attachment;
            AbstractHttpClientTransport.this.connectFailed(context, x);
        }
    }
}

