/*
 * Decompiled with CFR 0.152.
 */
package com.andexert.calendarlistview.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.ViewGroup;
import com.andexert.calendarlistview.library.DatePickerController;
import com.andexert.calendarlistview.library.R;
import com.andexert.calendarlistview.library.SimpleMonthAdapter;
import com.andexert.calendarlistview.library.SimpleMonthView;

public class DayPickerView
extends RecyclerView {
    protected Context mContext;
    protected SimpleMonthAdapter mAdapter;
    private DatePickerController mController;
    protected int mCurrentScrollState = 0;
    protected long mPreviousScrollPosition;
    protected int mPreviousScrollState = 0;
    private TypedArray typedArray;
    private RecyclerView.OnScrollListener onScrollListener;

    public DayPickerView(Context context) {
        this(context, null);
    }

    public DayPickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DayPickerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (!this.isInEditMode()) {
            this.typedArray = context.obtainStyledAttributes(attrs, R.styleable.DayPickerView);
            this.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -1));
            this.init(context);
        }
    }

    public void setController(DatePickerController mController) {
        this.mController = mController;
        this.setUpAdapter();
        this.setAdapter(this.mAdapter);
    }

    public void init(Context paramContext) {
        this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(paramContext));
        this.mContext = paramContext;
        this.setUpListView();
        this.onScrollListener = new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                SimpleMonthView child = (SimpleMonthView)recyclerView.getChildAt(0);
                if (child == null) {
                    return;
                }
                DayPickerView.this.mPreviousScrollPosition = dy;
                DayPickerView.this.mPreviousScrollState = DayPickerView.this.mCurrentScrollState;
            }
        };
    }

    protected void setUpAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = new SimpleMonthAdapter(this.getContext(), this.mController, this.typedArray);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    protected void setUpListView() {
        this.setVerticalScrollBarEnabled(false);
        this.setOnScrollListener(this.onScrollListener);
        this.setFadingEdgeLength(0);
    }

    public SimpleMonthAdapter.SelectedDays<SimpleMonthAdapter.CalendarDay> getSelectedDays() {
        return this.mAdapter.getSelectedDays();
    }

    protected DatePickerController getController() {
        return this.mController;
    }

    protected TypedArray getTypedArray() {
        return this.typedArray;
    }
}

