/*
 * Decompiled with CFR 0.152.
 */
package com.andexert.calendarlistview.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import com.andexert.calendarlistview.library.DatePickerController;
import com.andexert.calendarlistview.library.R;
import com.andexert.calendarlistview.library.SimpleMonthView;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class SimpleMonthAdapter
extends RecyclerView.Adapter<ViewHolder>
implements SimpleMonthView.OnDayClickListener {
    protected static final int MONTHS_IN_YEAR = 12;
    private final TypedArray typedArray;
    private final Context mContext;
    private final DatePickerController mController;
    private final Calendar calendar;
    private final SelectedDays<CalendarDay> selectedDays;
    private final Integer firstMonth;
    private final Integer lastMonth;

    public SimpleMonthAdapter(Context context, DatePickerController datePickerController, TypedArray typedArray) {
        this.typedArray = typedArray;
        this.calendar = Calendar.getInstance();
        this.firstMonth = typedArray.getInt(R.styleable.DayPickerView_firstMonth, this.calendar.get(2));
        this.lastMonth = typedArray.getInt(R.styleable.DayPickerView_lastMonth, (this.calendar.get(2) - 1) % 12);
        this.selectedDays = new SelectedDays();
        this.mContext = context;
        this.mController = datePickerController;
        this.init();
    }

    public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int i) {
        SimpleMonthView simpleMonthView = new SimpleMonthView(this.mContext, this.typedArray);
        return new ViewHolder(simpleMonthView, this);
    }

    public void onBindViewHolder(ViewHolder viewHolder, int position) {
        SimpleMonthView v = viewHolder.simpleMonthView;
        HashMap<String, Integer> drawingParams = new HashMap<String, Integer>();
        int month = (this.firstMonth + position % 12) % 12;
        int year = position / 12 + this.calendar.get(1) + (this.firstMonth + position % 12) / 12;
        int selectedFirstDay = -1;
        int selectedLastDay = -1;
        int selectedFirstMonth = -1;
        int selectedLastMonth = -1;
        int selectedFirstYear = -1;
        int selectedLastYear = -1;
        if (this.selectedDays.getFirst() != null) {
            selectedFirstDay = this.selectedDays.getFirst().day;
            selectedFirstMonth = this.selectedDays.getFirst().month;
            selectedFirstYear = this.selectedDays.getFirst().year;
        }
        if (this.selectedDays.getLast() != null) {
            selectedLastDay = this.selectedDays.getLast().day;
            selectedLastMonth = this.selectedDays.getLast().month;
            selectedLastYear = this.selectedDays.getLast().year;
        }
        v.reuse();
        drawingParams.put("selected_begin_year", selectedFirstYear);
        drawingParams.put("selected_last_year", selectedLastYear);
        drawingParams.put("selected_begin_month", selectedFirstMonth);
        drawingParams.put("selected_last_month", selectedLastMonth);
        drawingParams.put("selected_begin_day", selectedFirstDay);
        drawingParams.put("selected_last_day", selectedLastDay);
        drawingParams.put("year", year);
        drawingParams.put("month", month);
        drawingParams.put("week_start", this.calendar.getFirstDayOfWeek());
        v.setMonthParams(drawingParams);
        v.invalidate();
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        int itemCount = (this.mController.getMaxYear() - this.calendar.get(1) + 1) * 12;
        if (this.firstMonth != -1) {
            itemCount -= this.firstMonth.intValue();
        }
        if (this.lastMonth != -1) {
            itemCount -= 12 - this.lastMonth - 1;
        }
        return itemCount;
    }

    protected void init() {
        if (this.typedArray.getBoolean(R.styleable.DayPickerView_currentDaySelected, false)) {
            this.onDayTapped(new CalendarDay(System.currentTimeMillis()));
        }
    }

    @Override
    public void onDayClick(SimpleMonthView simpleMonthView, CalendarDay calendarDay) {
        if (calendarDay != null) {
            this.onDayTapped(calendarDay);
        }
    }

    protected void onDayTapped(CalendarDay calendarDay) {
        this.mController.onDayOfMonthSelected(calendarDay.year, calendarDay.month, calendarDay.day);
        this.setSelectedDay(calendarDay);
    }

    public void setSelectedDay(CalendarDay calendarDay) {
        if (this.selectedDays.getFirst() != null && this.selectedDays.getLast() == null) {
            this.selectedDays.setLast(calendarDay);
            if (this.selectedDays.getFirst().month < calendarDay.month) {
                for (int i = 0; i < this.selectedDays.getFirst().month - calendarDay.month - 1; ++i) {
                    this.mController.onDayOfMonthSelected(this.selectedDays.getFirst().year, this.selectedDays.getFirst().month + i, this.selectedDays.getFirst().day);
                }
            }
            this.mController.onDateRangeSelected(this.selectedDays);
        } else if (this.selectedDays.getLast() != null) {
            this.selectedDays.setFirst(calendarDay);
            this.selectedDays.setLast(null);
        } else {
            this.selectedDays.setFirst(calendarDay);
        }
        this.notifyDataSetChanged();
    }

    public SelectedDays<CalendarDay> getSelectedDays() {
        return this.selectedDays;
    }

    public static class SelectedDays<K>
    implements Serializable {
        private static final long serialVersionUID = 3942549765282708376L;
        private K first;
        private K last;

        public K getFirst() {
            return this.first;
        }

        public void setFirst(K first) {
            this.first = first;
        }

        public K getLast() {
            return this.last;
        }

        public void setLast(K last) {
            this.last = last;
        }
    }

    public static class CalendarDay
    implements Serializable {
        private static final long serialVersionUID = -5456695978688356202L;
        private Calendar calendar;
        int day;
        int month;
        int year;

        public CalendarDay() {
            this.setTime(System.currentTimeMillis());
        }

        public CalendarDay(int year, int month, int day) {
            this.setDay(year, month, day);
        }

        public CalendarDay(long timeInMillis) {
            this.setTime(timeInMillis);
        }

        public CalendarDay(Calendar calendar) {
            this.year = calendar.get(1);
            this.month = calendar.get(2);
            this.day = calendar.get(5);
        }

        private void setTime(long timeInMillis) {
            if (this.calendar == null) {
                this.calendar = Calendar.getInstance();
            }
            this.calendar.setTimeInMillis(timeInMillis);
            this.month = this.calendar.get(2);
            this.year = this.calendar.get(1);
            this.day = this.calendar.get(5);
        }

        public void set(CalendarDay calendarDay) {
            this.year = calendarDay.year;
            this.month = calendarDay.month;
            this.day = calendarDay.day;
        }

        public void setDay(int year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
        }

        public Date getDate() {
            if (this.calendar == null) {
                this.calendar = Calendar.getInstance();
            }
            this.calendar.set(this.year, this.month, this.day);
            return this.calendar.getTime();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{ year: ");
            stringBuilder.append(this.year);
            stringBuilder.append(", month: ");
            stringBuilder.append(this.month);
            stringBuilder.append(", day: ");
            stringBuilder.append(this.day);
            stringBuilder.append(" }");
            return stringBuilder.toString();
        }
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        final SimpleMonthView simpleMonthView;

        public ViewHolder(View itemView, SimpleMonthView.OnDayClickListener onDayClickListener) {
            super(itemView);
            this.simpleMonthView = (SimpleMonthView)itemView;
            this.simpleMonthView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
            this.simpleMonthView.setClickable(true);
            this.simpleMonthView.setOnDayClickListener(onDayClickListener);
        }
    }
}

