/*
 * Decompiled with CFR 0.152.
 */
package com.udevel.widgetlab;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.udevel.widgetlab.DotView;
import java.util.ArrayList;

public class BouncingSlidingDotView
extends DotView {
    private final Paint paint = new Paint();
    private final Rect clipRect = new Rect();
    private int centerX;
    private int centerY;
    private float radius;
    private int startLeft;
    private int targetLeft;
    private int targetTop;
    private int indexToParent = Integer.MIN_VALUE;
    private long ratioAnimationTotalDuration = 100L;
    private long growDisappearAnimationDuration = 100L;
    private float radiusScale = 0.0f;
    private float compressRatio = 0.2f;
    private int startTop;
    private AnimatorSet animatorSet;

    public BouncingSlidingDotView(Context context) {
        super(context);
    }

    protected void onDraw(Canvas canvas) {
        this.paint.setColor(this.dotColor);
        canvas.save();
        canvas.getClipBounds(this.clipRect);
        this.clipRect.inset(-this.targetLeft, 0);
        canvas.translate((float)(-this.targetLeft), 0.0f);
        canvas.drawCircle((float)this.centerX, (float)(this.targetTop + this.centerY), this.radius * this.radiusScale, this.paint);
        canvas.restore();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.indexToParent = this.findIndexToParent((ViewGroup)this.getParent());
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        ViewGroup parent = (ViewGroup)this.getParent();
        this.startLeft = left;
        this.startTop = top;
        this.centerX = this.getWidth() / 2;
        this.centerY = this.getHeight() / 2;
        this.radius = Math.min(this.centerX, this.centerY);
        this.ratioAnimationTotalDuration = (long)((float)(this.animationTotalDuration / 2L) * ((float)this.findIndexToParent(parent) + 1.0f) / (float)parent.getChildCount());
    }

    @Override
    public void setAnimationDuration(long duration) {
        super.setAnimationDuration(duration);
        this.growDisappearAnimationDuration = this.animationTotalDuration / 2L;
    }

    @Override
    protected void init() {
    }

    @Override
    public void startDotAnimation() {
        this.stopDotAnimation();
        if (this.animatorSet == null) {
            this.animatorSet = new AnimatorSet();
            AnimatorSet moveAnimatorSet = this.getMoveAnimator(this.ratioAnimationTotalDuration);
            AnimatorSet growDisappearAnimatorSet = this.getGrowDisappearAnimator(this.growDisappearAnimationDuration);
            this.animatorSet.playSequentially(new Animator[]{moveAnimatorSet, growDisappearAnimatorSet});
            this.animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    BouncingSlidingDotView.this.radiusScale = BouncingSlidingDotView.this.compressRatio;
                    BouncingSlidingDotView.this.dotColor = BouncingSlidingDotView.this.dotSecondColor;
                }
            });
        }
        this.animatorSet.start();
    }

    @Override
    public void stopDotAnimation() {
        if (this.animatorSet != null && this.animatorSet.isStarted()) {
            this.animatorSet.cancel();
        }
    }

    @Override
    public boolean isAnimating() {
        return this.animatorSet != null && this.animatorSet.isStarted();
    }

    @Override
    protected void setMaxCompressRatio(@FloatRange(from=0.0, to=1.0) float compressRatio) {
        this.compressRatio = compressRatio;
    }

    @NonNull
    private AnimatorSet getMoveAnimator(long ratioAnimationTotalDuration) {
        AnimatorSet moveAnimatorSet = new AnimatorSet();
        ValueAnimator slidingAnimator = ValueAnimator.ofInt((int[])new int[]{this.startLeft, 0});
        slidingAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                BouncingSlidingDotView.this.targetLeft = (Integer)animator.getAnimatedValue();
                BouncingSlidingDotView.this.invalidate();
            }
        });
        slidingAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        slidingAnimator.setDuration(ratioAnimationTotalDuration);
        AnimatorSet bounceSet = this.getBounceAnimatorSet(ratioAnimationTotalDuration);
        moveAnimatorSet.playTogether(new Animator[]{slidingAnimator, bounceSet});
        return moveAnimatorSet;
    }

    @NonNull
    private AnimatorSet getGrowDisappearAnimator(long growDisappearAnimationDuration) {
        AnimatorSet growDisappearAnimatorSet = new AnimatorSet();
        ValueAnimator growAnimator = ValueAnimator.ofFloat((float[])new float[]{this.compressRatio, 1.0f});
        growAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                BouncingSlidingDotView.this.radiusScale = ((Float)animator.getAnimatedValue()).floatValue();
                BouncingSlidingDotView.this.invalidate();
            }
        });
        growAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        growAnimator.setDuration(growDisappearAnimationDuration);
        ValueAnimator fadeAnimator = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{this.dotSecondColor, 0});
        fadeAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                BouncingSlidingDotView.this.dotColor = (Integer)animator.getAnimatedValue();
                BouncingSlidingDotView.this.invalidate();
            }
        });
        fadeAnimator.setDuration(growDisappearAnimationDuration);
        fadeAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        growDisappearAnimatorSet.playTogether(new Animator[]{growAnimator, fadeAnimator});
        return growDisappearAnimatorSet;
    }

    @NonNull
    private AnimatorSet getBounceAnimatorSet(long bounceDuration) {
        AnimatorSet bounceSet = new AnimatorSet();
        ArrayList<ValueAnimator> bounceAnimatorList = new ArrayList<ValueAnimator>();
        ValueAnimator initialDownAnimator = ValueAnimator.ofInt((int[])new int[]{-this.startTop, 0});
        initialDownAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                BouncingSlidingDotView.this.targetTop = (Integer)animator.getAnimatedValue();
            }
        });
        initialDownAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        bounceAnimatorList.add(initialDownAnimator);
        for (int i = 0; i < this.indexToParent; ++i) {
            ValueAnimator upAnimator = ValueAnimator.ofInt((int[])new int[]{0, -this.startTop});
            upAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animator) {
                    BouncingSlidingDotView.this.targetTop = (Integer)animator.getAnimatedValue();
                }
            });
            upAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            bounceAnimatorList.add(upAnimator);
            ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{-this.startTop, 0});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animator) {
                    BouncingSlidingDotView.this.targetTop = (Integer)animator.getAnimatedValue();
                }
            });
            valueAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            bounceAnimatorList.add(valueAnimator);
        }
        int size = bounceAnimatorList.size();
        for (Animator animator : bounceAnimatorList) {
            animator.setDuration(bounceDuration / (long)size);
        }
        bounceSet.playSequentially(bounceAnimatorList);
        return bounceSet;
    }

    private int findIndexToParent(@NonNull ViewGroup parent) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (parent.getChildAt(i) != this) continue;
            return i;
        }
        return -1;
    }
}

