/*
 * Decompiled with CFR 0.152.
 */
package com.udevel.widgetlab;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.FloatRange;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import com.udevel.widgetlab.DotView;

public class DisappearDotView
extends DotView {
    private final Paint paint = new Paint();
    private int centerX;
    private int centerY;
    private float radius;
    private boolean isAnimatingDisappear = false;
    private float scale = 1.0f;
    private AnimatorSet animatorDisappearSet;
    private AnimatorSet animatorAppearSet;

    public DisappearDotView(Context context) {
        super(context);
    }

    protected void onDraw(Canvas canvas) {
        this.paint.setColor(this.dotColor);
        canvas.drawCircle((float)this.centerX, (float)this.centerY, this.radius * this.scale, this.paint);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.centerX = this.getWidth() / 2;
        this.centerY = this.getHeight() / 2;
        this.radius = (float)Math.min(this.centerX, this.centerY) / 1.2f;
    }

    @Override
    protected void init() {
    }

    @Override
    public void startDotAnimation() {
        this.stopDotAnimation();
        if (this.isAnimatingDisappear) {
            this.isAnimatingDisappear = false;
            if (this.animatorAppearSet == null) {
                this.animatorAppearSet = new AnimatorSet();
                ValueAnimator appearAnimator = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{this.dotSecondColor, this.dotFirstColor});
                appearAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animator) {
                        DisappearDotView.this.dotColor = (Integer)animator.getAnimatedValue();
                        DisappearDotView.this.invalidate();
                    }
                });
                appearAnimator.setDuration(this.animationTotalDuration);
                appearAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
                ValueAnimator growAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                growAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animator) {
                        DisappearDotView.this.scale = ((Float)animator.getAnimatedValue()).floatValue();
                    }
                });
                growAnimator.setDuration(this.animationTotalDuration);
                growAnimator.setInterpolator((TimeInterpolator)new OvershootInterpolator());
                this.animatorAppearSet.playTogether(new Animator[]{appearAnimator, growAnimator});
            }
            this.animatorAppearSet.start();
        } else {
            this.isAnimatingDisappear = true;
            if (this.animatorDisappearSet == null) {
                this.animatorDisappearSet = new AnimatorSet();
                ValueAnimator disappearAnimator = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{this.dotFirstColor, this.dotSecondColor});
                disappearAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animator) {
                        DisappearDotView.this.dotColor = (Integer)animator.getAnimatedValue();
                        DisappearDotView.this.invalidate();
                    }
                });
                disappearAnimator.setDuration(this.animationTotalDuration);
                disappearAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
                ValueAnimator shrinkAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
                shrinkAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animator) {
                        DisappearDotView.this.scale = ((Float)animator.getAnimatedValue()).floatValue();
                    }
                });
                shrinkAnimator.setDuration(this.animationTotalDuration);
                shrinkAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                this.animatorDisappearSet.playTogether(new Animator[]{disappearAnimator, shrinkAnimator});
            }
            this.animatorDisappearSet.start();
        }
    }

    @Override
    public void stopDotAnimation() {
        if (this.animatorDisappearSet != null && this.animatorDisappearSet.isStarted()) {
            this.animatorDisappearSet.cancel();
        }
        if (this.animatorAppearSet != null && this.animatorAppearSet.isStarted()) {
            this.animatorAppearSet.cancel();
        }
    }

    @Override
    public boolean isAnimating() {
        return this.animatorDisappearSet != null && this.animatorDisappearSet.isStarted() || this.animatorAppearSet != null && this.animatorAppearSet.isStarted();
    }

    @Override
    protected void setMaxCompressRatio(@FloatRange(from=0.0, to=1.0) float compressRatio) {
    }
}

