/*
 * Decompiled with CFR 0.152.
 */
package com.udevel.widgetlab;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.FloatRange;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import com.udevel.widgetlab.DotView;

public class SlidingDotView
extends DotView {
    private final Paint paint = new Paint();
    private final Rect clipRect = new Rect();
    private int centerX;
    private int centerY;
    private float radius;
    private boolean isAnimatingDisappear = true;
    private int parentLeft;
    private int parentRight;
    private int targetLeft;
    private int parentWidth;
    private AnimatorSet animatorDisappearSet;
    private AnimatorSet animatorAppearSet;

    public SlidingDotView(Context context) {
        super(context);
    }

    protected void onDraw(Canvas canvas) {
        this.paint.setColor(this.dotColor);
        canvas.getClipBounds(this.clipRect);
        this.clipRect.inset(-this.parentLeft + this.targetLeft, 0);
        canvas.save();
        canvas.translate((float)(-this.parentLeft + this.targetLeft), 0.0f);
        canvas.drawCircle((float)this.centerX, (float)this.centerY, this.radius, this.paint);
        canvas.restore();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.parentLeft = left + this.getWidth();
        this.parentWidth = ((View)this.getParent()).getWidth();
        this.parentRight = this.parentWidth - left;
        this.centerX = this.getWidth() / 2;
        this.centerY = this.getHeight() / 2;
        this.radius = Math.min(this.centerX, this.centerY);
    }

    @Override
    protected void init() {
    }

    @Override
    public void startDotAnimation() {
        int width = this.getWidth();
        float ratioDxLeft = ((float)this.parentLeft - (float)width / 2.0f) / ((float)this.parentWidth / 2.0f);
        float ratioDxRight = ((float)this.parentRight - (float)width / 2.0f) / ((float)this.parentWidth / 2.0f);
        this.stopDotAnimation();
        if (this.isAnimatingDisappear) {
            this.isAnimatingDisappear = false;
            if (this.animatorAppearSet == null) {
                this.animatorAppearSet = new AnimatorSet();
                ValueAnimator appearAnimator = ValueAnimator.ofInt((int[])new int[]{0, this.parentLeft});
                appearAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animator) {
                        SlidingDotView.this.targetLeft = (Integer)animator.getAnimatedValue();
                        SlidingDotView.this.invalidate();
                    }
                });
                appearAnimator.setDuration((long)((double)this.animationTotalDuration * Math.sqrt(ratioDxLeft)));
                appearAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                ValueAnimator colorAnimator = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{this.dotSecondColor, this.dotFirstColor});
                colorAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animator) {
                        SlidingDotView.this.dotColor = (Integer)animator.getAnimatedValue();
                    }
                });
                colorAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        SlidingDotView.this.dotColor = SlidingDotView.this.dotFirstColor;
                    }
                });
                colorAnimator.setDuration(this.animationTotalDuration);
                colorAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
                this.animatorAppearSet.playTogether(new Animator[]{appearAnimator, colorAnimator});
            }
            this.animatorAppearSet.start();
        } else {
            this.isAnimatingDisappear = true;
            if (this.animatorDisappearSet == null) {
                this.animatorDisappearSet = new AnimatorSet();
                ValueAnimator disappearAnimator = ValueAnimator.ofInt((int[])new int[]{this.parentLeft, this.parentLeft + this.parentRight + width});
                disappearAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animator) {
                        SlidingDotView.this.targetLeft = (Integer)animator.getAnimatedValue();
                        SlidingDotView.this.invalidate();
                    }
                });
                disappearAnimator.setDuration((long)((double)this.animationTotalDuration * Math.sqrt(ratioDxRight)));
                disappearAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                this.animatorDisappearSet.play((Animator)disappearAnimator);
            }
            this.animatorDisappearSet.start();
        }
    }

    @Override
    public void stopDotAnimation() {
        if (this.animatorDisappearSet != null && this.animatorDisappearSet.isStarted()) {
            this.animatorDisappearSet.cancel();
        }
        if (this.animatorAppearSet != null && this.animatorAppearSet.isStarted()) {
            this.animatorAppearSet.cancel();
        }
    }

    @Override
    public boolean isAnimating() {
        return this.animatorDisappearSet != null && this.animatorDisappearSet.isStarted() || this.animatorAppearSet != null && this.animatorAppearSet.isStarted();
    }

    @Override
    protected void setMaxCompressRatio(@FloatRange(from=0.0, to=1.0) float compressRatio) {
    }
}

