/*
 * Decompiled with CFR 0.152.
 */
package com.udevel.widgetlab;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.udevel.widgetlab.BouncingSlidingDotView;
import com.udevel.widgetlab.DisappearDotView;
import com.udevel.widgetlab.DotView;
import com.udevel.widgetlab.GrowDotView;
import com.udevel.widgetlab.R;
import com.udevel.widgetlab.SlidingDotView;
import com.udevel.widgetlab.WinkDotView;
import com.udevel.widgetlab.sequences.CircularSequenceGenerator;
import com.udevel.widgetlab.sequences.InSequenceGenerator;
import com.udevel.widgetlab.sequences.RandomNoRepetitionSequenceGenerator;
import com.udevel.widgetlab.sequences.RandomSequenceGenerator;
import com.udevel.widgetlab.sequences.ReverseSequenceGenerator;
import com.udevel.widgetlab.sequences.SequenceGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TypingIndicatorView
extends LinearLayout {
    private static final String TAG = TypingIndicatorView.class.getSimpleName();
    private static final int BACKGROUND_TYPE_DEF_VALUE = 0;
    private static final int BACKGROUND_COLOR_DEF_VALUE = -3355444;
    private static final int DOT_ANIMATION_TYPE_DEF_VALUE = 0;
    private static final int DOT_COUNT_DEF_VALUE = 3;
    private static final int DOT_SIZE_DEF_VALUE = 24;
    private static final int DOT_COLOR_DEF_VALUE = -3355444;
    private static final float DOT_MAX_COMPRESS_RATIO_DEF_VALUE = 0.5f;
    private static final int DOT_ANIMATION_DURATION_DEF_VALUE = 600;
    private static final int DOT_HORIZONTAL_SPACING_DEF_VALUE = 20;
    private static final int ANIMATE_ORDER_DEF_VALUE = 0;
    private static final int ANIMATE_FREQUENCY_DEF_VALUE = 1000;
    private final Handler handler = new Handler();
    private final Random random = new Random();
    private final List<DotView> dotViewList = new ArrayList<DotView>();
    @IntRange(from=1L)
    private int numOfDots;
    private boolean isAnimationStarted;
    @IntRange(from=0L)
    private int dotHorizontalSpacing;
    @IntRange(from=1L)
    private int dotSize;
    @FloatRange(from=0.0, to=1.0)
    private float dotMaxCompressRatio;
    private boolean isShowBackground;
    private int backgroundType;
    @ColorInt
    private int backgroundColor;
    private int dotAnimationType;
    @ColorInt
    private int dotColor;
    @ColorInt
    private int dotSecondColor;
    @IntRange(from=1L)
    private int dotAnimationDuration;
    @IntRange(from=1L)
    private int animateFrequency;
    private Paint backgroundPaint;
    private SequenceGenerator sequenceGenerator;
    private final Runnable dotAnimationRunnable = new Runnable(){

        @Override
        public void run() {
            long delayMillis;
            int nextAnimateDotIndex = TypingIndicatorView.this.sequenceGenerator.nextIndex(TypingIndicatorView.this.numOfDots);
            ((DotView)((Object)TypingIndicatorView.this.dotViewList.get(nextAnimateDotIndex))).startDotAnimation();
            long l = delayMillis = (long)TypingIndicatorView.this.animateFrequency < 0L ? (long)(500.0f + 2000.0f * TypingIndicatorView.this.random.nextFloat()) : (long)TypingIndicatorView.this.animateFrequency;
            if (TypingIndicatorView.this.isAnimationStarted) {
                TypingIndicatorView.this.handler.postDelayed(TypingIndicatorView.this.dotAnimationRunnable, delayMillis);
            }
        }
    };

    public TypingIndicatorView(Context context) {
        this(context, null);
    }

    public TypingIndicatorView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TypingIndicatorView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.parseAttributes(context, attrs);
        this.init();
    }

    public static Path composeRoundedRectPath(float left, float top, float right, float bottom, float radius) {
        Log.d((String)TAG, (String)("composeRoundedRectPath() called with: left = [" + left + "], top = [" + top + "], right = [" + right + "], bottom = [" + bottom + "], radius = [" + radius + "]"));
        Path path = new Path();
        path.moveTo(left + radius, top);
        path.lineTo(right - radius, top);
        path.quadTo(right - radius / 2.0f, top - radius / 2.0f, right, top + radius);
        path.lineTo(right, bottom - radius);
        path.quadTo(right, bottom, right - radius, bottom);
        path.lineTo(left + radius, bottom);
        path.quadTo(left, bottom, left, bottom - radius);
        path.lineTo(left, top + radius);
        path.quadTo(left, top, left + radius, top);
        path.close();
        return path;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            if (this.getVisibility() == 0) {
                this.startDotAnimation();
            }
        } else {
            this.stopDotAnimation();
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            this.startDotAnimation();
        } else {
            this.stopDotAnimation();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.getVisibility() == 0) {
            this.startDotAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopDotAnimation();
    }

    protected void onDraw(Canvas canvas) {
        int radius = Math.min(this.getWidth(), this.getHeight()) / 2;
        switch (this.backgroundType) {
            case 1: {
                canvas.drawCircle((float)radius, (float)radius, (float)radius, this.backgroundPaint);
                canvas.drawCircle((float)(this.getWidth() - radius), (float)radius, (float)radius, this.backgroundPaint);
                canvas.drawRect((float)radius, 0.0f, (float)(this.getWidth() - radius), (float)this.getHeight(), this.backgroundPaint);
                break;
            }
            default: {
                canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.backgroundPaint);
            }
        }
    }

    @UiThread
    public void stopDotAnimation() {
        this.isAnimationStarted = false;
        try {
            this.handler.removeCallbacks(this.dotAnimationRunnable);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"stopDotAnimation: weird crash", (Throwable)ex);
        }
    }

    @UiThread
    public void startDotAnimation() {
        if (this.isAnimationStarted) {
            return;
        }
        this.isAnimationStarted = true;
        this.handler.post(this.dotAnimationRunnable);
    }

    public boolean isAnimationStarted() {
        return this.isAnimationStarted;
    }

    public void setAnimationOrder(int animationOrder) {
        switch (animationOrder) {
            case 2: {
                this.sequenceGenerator = new CircularSequenceGenerator();
                break;
            }
            case 3: {
                this.sequenceGenerator = new ReverseSequenceGenerator();
                break;
            }
            case 4: {
                this.sequenceGenerator = new RandomNoRepetitionSequenceGenerator();
                break;
            }
            case 1: {
                this.sequenceGenerator = new InSequenceGenerator();
                break;
            }
            case 0: {
                this.sequenceGenerator = new RandomSequenceGenerator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAttributes(@NonNull Context context, @Nullable AttributeSet attrs) {
        int animationOrder;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TypingIndicatorView, 0, 0);
        try {
            this.dotSize = a.getDimensionPixelOffset(R.styleable.TypingIndicatorView_dotSize, 24);
            this.numOfDots = a.getInteger(R.styleable.TypingIndicatorView_dotCount, 3);
            this.dotHorizontalSpacing = a.getDimensionPixelOffset(R.styleable.TypingIndicatorView_dotHorizontalSpacing, 20);
            this.dotColor = a.getColor(R.styleable.TypingIndicatorView_dotColor, -3355444);
            this.dotSecondColor = a.getColor(R.styleable.TypingIndicatorView_dotSecondColor, this.dotColor);
            this.dotMaxCompressRatio = a.getFraction(R.styleable.TypingIndicatorView_dotMaxCompressRatio, 1, 1, 0.5f);
            this.dotAnimationDuration = a.getInteger(R.styleable.TypingIndicatorView_dotAnimationDuration, 600);
            this.dotAnimationType = a.getInteger(R.styleable.TypingIndicatorView_dotAnimationType, 0);
            this.isShowBackground = a.getBoolean(R.styleable.TypingIndicatorView_showBackground, false);
            this.backgroundType = a.getInteger(R.styleable.TypingIndicatorView_backgroundType, 0);
            this.backgroundColor = a.getColor(R.styleable.TypingIndicatorView_backgroundColor, -3355444);
            animationOrder = a.getInteger(R.styleable.TypingIndicatorView_animationOrder, 0);
            this.animateFrequency = a.getInteger(R.styleable.TypingIndicatorView_animateFrequency, Math.max(this.dotAnimationDuration, 1000));
        }
        finally {
            a.recycle();
        }
        if (this.dotMaxCompressRatio > 1.0f || this.dotMaxCompressRatio < 0.0f) {
            throw new IllegalArgumentException("dotMaxCompressRatio must be between 0% and 100%");
        }
        if (this.dotAnimationType == 2) {
            animationOrder = 1;
        }
        this.setAnimationOrder(animationOrder);
    }

    private void init() {
        this.setClipToPadding(false);
        this.setClipChildren(false);
        if (this.isShowBackground) {
            this.setWillNotDraw(false);
            this.backgroundPaint = new Paint();
            this.backgroundPaint.setColor(this.backgroundColor);
        }
        int halfHorizontalSpacing = this.dotHorizontalSpacing / 2;
        for (int i = 0; i < this.numOfDots; ++i) {
            DotView dotView = this.createDotView(this.dotAnimationType);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(this.dotSize, this.dotSize);
            layoutParams.setMargins(halfHorizontalSpacing, 0, halfHorizontalSpacing, 0);
            this.addView(dotView, (ViewGroup.LayoutParams)layoutParams);
            this.dotViewList.add(dotView);
        }
    }

    private DotView createDotView(int dotAnimationType) {
        DotView dotView;
        Context context = this.getContext();
        switch (dotAnimationType) {
            case 4: {
                dotView = new BouncingSlidingDotView(context);
                break;
            }
            case 3: {
                dotView = new SlidingDotView(context);
                break;
            }
            case 1: {
                dotView = new WinkDotView(context);
                break;
            }
            case 2: {
                dotView = new DisappearDotView(context);
                break;
            }
            default: {
                dotView = new GrowDotView(context);
            }
        }
        dotView.setAnimationDuration(this.dotAnimationDuration);
        dotView.setMaxCompressRatio(this.dotMaxCompressRatio);
        dotView.setColor(this.dotColor);
        dotView.setSecondColor(this.dotSecondColor);
        return dotView;
    }
}

