/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.process;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BulkIterator<S>
implements Iterator<List<S>> {
    private Iterator<S> original;
    private final int maxBulk;
    private int bulk;
    private int multiplier;
    private List<S> current;

    public BulkIterator(int maxBulk, int startBulk, int multiplier, Iterator<S> original) {
        this.original = original;
        this.maxBulk = maxBulk;
        this.bulk = startBulk;
        this.multiplier = multiplier;
    }

    @Override
    public boolean hasNext() {
        if (!this.original.hasNext()) {
            return false;
        }
        ArrayList<S> list = new ArrayList<S>(this.bulk);
        for (int i = 0; i < this.bulk; ++i) {
            if (!this.original.hasNext()) continue;
            list.add(this.original.next());
        }
        this.bulk = Math.min(this.bulk * this.multiplier, this.maxBulk);
        this.current = list;
        return this.current.size() > 0;
    }

    @Override
    public List<S> next() {
        return this.current;
    }
}

