/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.process;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.util.iterator.EmptyIterator;
import org.unipop.process.BulkIterator;
import org.unipop.structure.UniGraph;
import org.unipop.util.ConversionUtils;

public abstract class UniBulkStep<S, E>
extends AbstractStep<S, E> {
    protected final int maxBulk;
    protected int startBulk;
    protected int multiplier;
    protected Iterator<Traverser.Admin<E>> results = EmptyIterator.instance();

    public UniBulkStep(Traversal.Admin traversal, UniGraph graph) {
        super(traversal);
        this.maxBulk = graph.configuration().getInt("bulk.max", 100);
        this.startBulk = graph.configuration().getInt("bulk.start", this.maxBulk);
        this.multiplier = graph.configuration().getInt("bulk.multiplier", 2);
    }

    protected Traverser.Admin<E> processNextStart() throws NoSuchElementException {
        if (!this.results.hasNext() && this.starts.hasNext()) {
            this.results = this.process();
        }
        if (this.results.hasNext()) {
            return this.results.next();
        }
        throw FastNoSuchElementException.instance();
    }

    private Iterator<Traverser.Admin<E>> process() {
        BulkIterator partitionedTraversers = new BulkIterator(this.maxBulk, this.startBulk, this.multiplier, this.starts);
        return ConversionUtils.asStream(partitionedTraversers).map(this::process).flatMap(ConversionUtils::asStream).iterator();
    }

    protected abstract Iterator<Traverser.Admin<E>> process(List<Traverser.Admin<S>> var1);

    public void reset() {
        super.reset();
        this.results = EmptyIterator.instance();
    }
}

