/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.process.order;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ElementValueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DedupGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WhereTraversalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.javatuples.Pair;
import org.unipop.process.edge.EdgeStepsStrategy;
import org.unipop.process.order.Orderable;
import org.unipop.process.predicate.ReceivesPredicatesHolder;
import org.unipop.process.repeat.UniGraphRepeatStepStrategy;
import org.unipop.process.start.UniGraphStartStepStrategy;
import org.unipop.process.vertex.UniGraphVertexStepStrategy;

public class UniGraphOrderStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPrior() {
        return Sets.newHashSet((Object[])new Class[]{UniGraphStartStepStrategy.class, UniGraphVertexStepStrategy.class, UniGraphRepeatStepStrategy.class, EdgeStepsStrategy.class});
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        TraversalHelper.getStepsOfAssignableClass(OrderGlobalStep.class, traversal).forEach(orderGlobalStep -> {
            List comparators = orderGlobalStep.getComparators();
            List<Pair<String, Order>> collect = comparators.stream().filter(pair -> pair.getValue0() instanceof ElementValueTraversal).filter(pair -> pair.getValue1() instanceof Order).map(pair -> Pair.with((Object)((ElementValueTraversal)pair.getValue0()).getPropertyKey(), (Object)((Order)pair.getValue1()))).collect(Collectors.toList());
            Collection<Orderable> orderableStepOf = this.getOrderableStepOf((Step)orderGlobalStep, traversal);
            if (orderableStepOf != null && orderableStepOf.size() == 1) {
                Orderable step = orderableStepOf.iterator().next();
                step.setOrders(collect);
                Step nextStep = orderGlobalStep.getNextStep();
                if (nextStep instanceof RangeGlobalStep && step instanceof ReceivesPredicatesHolder) {
                    RangeGlobalStep rangeGlobalStep = (RangeGlobalStep)nextStep;
                    int limit = rangeGlobalStep.getHighRange() > Integer.MAX_VALUE ? -1 : (int)rangeGlobalStep.getHighRange();
                    ((ReceivesPredicatesHolder)((Object)step)).setLimit(limit);
                }
            }
        });
    }

    private Collection<Orderable> getOrderableStepOf(Step step, Traversal.Admin<?, ?> traversal) {
        Step previous = step.getPreviousStep();
        while (!(previous instanceof Orderable)) {
            if (previous instanceof DedupGlobalStep || previous instanceof OrderGlobalStep) {
                previous = previous.getPreviousStep();
                continue;
            }
            if (previous instanceof EmptyStep) {
                TraversalParent parent = traversal.getParent();
                List Orderables = parent.getLocalChildren().stream().flatMap(child -> TraversalHelper.getStepsOfAssignableClassRecursively(Orderable.class, (Traversal.Admin)child).stream()).collect(Collectors.toList());
                if (Orderables.size() > 0) {
                    previous = (Step)Orderables.get(Orderables.size() - 1);
                    continue;
                }
                return null;
            }
            if (previous instanceof TraversalParent) {
                List<Orderable> Orderables = Stream.concat(((TraversalParent)previous).getLocalChildren().stream(), ((TraversalParent)previous).getGlobalChildren().stream()).flatMap(child -> TraversalHelper.getStepsOfAssignableClassRecursively(Orderable.class, (Traversal.Admin)child).stream()).collect(Collectors.toList());
                if (Orderables.size() > 0) {
                    return Orderables;
                }
                return null;
            }
            if (previous instanceof WhereTraversalStep.WhereStartStep) {
                return null;
            }
            previous = previous.getPreviousStep();
        }
        return Collections.singleton((Orderable)previous);
    }
}

