/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.process.predicate;

import java.util.HashSet;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.unipop.process.predicate.ReceivesPredicatesHolder;
import org.unipop.query.predicates.PredicatesHolder;
import org.unipop.query.predicates.PredicatesHolderFactory;

public class PredicatesUtil {
    public static void collectPredicates(ReceivesPredicatesHolder step, Traversal.Admin traversal) {
        Step nextStep = step.getNextStep();
        HashSet<PredicatesHolder> predicates = new HashSet<PredicatesHolder>();
        while (true) {
            if (nextStep instanceof HasContainerHolder) {
                HasContainerHolder hasContainerHolder = (HasContainerHolder)nextStep;
                hasContainerHolder.getHasContainers().stream().map(PredicatesHolderFactory::predicate).forEach(predicates::add);
                traversal.removeStep(nextStep);
                if (PredicatesUtil.collectLabels(nextStep, step)) {
                    break;
                }
            } else {
                if (!(nextStep instanceof RangeGlobalStep)) break;
                RangeGlobalStep rangeGlobalStep = (RangeGlobalStep)nextStep;
                int limit = rangeGlobalStep.getHighRange() > Integer.MAX_VALUE ? -1 : (int)rangeGlobalStep.getHighRange();
                step.setLimit(limit);
                PredicatesUtil.collectLabels(nextStep, step);
                break;
            }
            nextStep = nextStep.getNextStep();
        }
        PredicatesHolder predicate = PredicatesHolderFactory.and(predicates);
        step.addPredicate(predicate);
    }

    private static boolean collectLabels(Step<?, ?> step, Step<?, ?> originalStep) {
        step.getLabels().forEach(arg_0 -> originalStep.addLabel(arg_0));
        return step.getLabels().size() > 0;
    }
}

