/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.process.predicate;

import java.util.function.BiPredicate;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.P;

public class Text {
    public static <V> P<V> like(V value) {
        return new P((BiPredicate)TextPredicate.LIKE, value);
    }

    public static <V> P<V> unlike(V value) {
        return new P((BiPredicate)TextPredicate.UNLIKE, value);
    }

    public static <V> P<V> regexp(V value) {
        return new P((BiPredicate)TextPredicate.REGEXP, value);
    }

    public static <V> P<V> unregexp(V value) {
        return new P((BiPredicate)TextPredicate.UNREGEXP, value);
    }

    public static <V> P<V> fuzzy(V value) {
        return new P((BiPredicate)TextPredicate.FUZZY, value);
    }

    public static <V> P<V> unfuzzy(V value) {
        return new P((BiPredicate)TextPredicate.UNFUZZY, value);
    }

    public static <V> P<V> prefix(V value) {
        return new P((BiPredicate)TextPredicate.PREFIX, value);
    }

    public static <V> P<V> unprefix(V value) {
        return new P((BiPredicate)TextPredicate.UNPREFIX, value);
    }

    public static enum TextPredicate implements BiPredicate<Object, Object>
    {
        PREFIX{

            @Override
            public boolean test(Object first, Object second) {
                return first.toString().startsWith(second.toString());
            }

            public TextPredicate negate() {
                return UNREGEXP;
            }
        }
        ,
        UNPREFIX{

            @Override
            public boolean test(Object first, Object second) {
                return !this.negate().test(first, second);
            }

            public TextPredicate negate() {
                return PREFIX;
            }
        }
        ,
        LIKE{

            @Override
            public boolean test(Object first, Object second) {
                return first.toString().matches(second.toString().replace("?", ".?").replace("*", ".*?"));
            }

            public TextPredicate negate() {
                return UNLIKE;
            }
        }
        ,
        UNLIKE{

            @Override
            public boolean test(Object first, Object second) {
                return !this.negate().test(first, second);
            }

            public TextPredicate negate() {
                return LIKE;
            }
        }
        ,
        REGEXP{

            @Override
            public boolean test(Object first, Object second) {
                return first.toString().matches(second.toString());
            }

            public TextPredicate negate() {
                return UNREGEXP;
            }
        }
        ,
        UNREGEXP{

            @Override
            public boolean test(Object first, Object second) {
                return !this.negate().test(first, second);
            }

            public TextPredicate negate() {
                return REGEXP;
            }
        }
        ,
        FUZZY{

            @Override
            public boolean test(Object first, Object second) {
                int levenshteinDistance = StringUtils.getLevenshteinDistance((String)second.toString(), (String)first.toString());
                return levenshteinDistance <= 3;
            }

            public TextPredicate negate() {
                return UNFUZZY;
            }
        }
        ,
        UNFUZZY{

            @Override
            public boolean test(Object first, Object second) {
                return !this.negate().test(first, second);
            }

            public TextPredicate negate() {
                return FUZZY;
            }
        };

    }
}

