/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.process.properties;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.DefaultGraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ElementValueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.LocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.ConnectiveStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DedupGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WherePredicateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WhereTraversalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddEdgeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FoldStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GroupCountStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GroupStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LambdaMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PathStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectOneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TraversalMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TreeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.TreeSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.unipop.process.edge.EdgeStepsStrategy;
import org.unipop.process.edge.UniGraphEdgeOtherVertexStep;
import org.unipop.process.edge.UniGraphEdgeVertexStep;
import org.unipop.process.properties.PropertyFetcher;
import org.unipop.process.repeat.UniGraphRepeatStep;
import org.unipop.process.repeat.UniGraphRepeatStepStrategy;
import org.unipop.process.start.UniGraphStartStepStrategy;
import org.unipop.process.vertex.UniGraphVertexStepStrategy;
import org.unipop.process.where.UniGraphWhereTraversalStep;

public class UniGraphPropertiesStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPrior() {
        return Sets.newHashSet((Object[])new Class[]{UniGraphStartStepStrategy.class, UniGraphVertexStepStrategy.class, UniGraphRepeatStepStrategy.class, EdgeStepsStrategy.class});
    }

    private void handlePropertiesSteps(String[] propertyKeys, PropertyFetcher propertyFetcher) {
        if (propertyFetcher != null) {
            if (propertyKeys.length > 0) {
                for (String key : propertyKeys) {
                    propertyFetcher.addPropertyKey(key);
                }
            } else {
                propertyFetcher.fetchAllKeys();
            }
        }
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        TraversalHelper.getStepsOfClass(OrderGlobalStep.class, traversal).forEach(orderGlobalStep -> {
            Collection<PropertyFetcher> propertyFetchers = this.getPropertyFetcherStepOf((Step)orderGlobalStep, traversal);
            if (propertyFetchers != null) {
                propertyFetchers.forEach(propertyFetcher -> {
                    if (traversal.getParent() instanceof ConnectiveStep || TraversalHelper.hasStepOfClass(MatchStep.MatchStartStep.class, (Traversal.Admin)traversal)) {
                        propertyFetcher.fetchAllKeys();
                    } else {
                        orderGlobalStep.getLocalChildren().forEach(t -> {
                            if (t instanceof ElementValueTraversal) {
                                String propertyKey = ((ElementValueTraversal)t).getPropertyKey();
                                this.handlePropertiesSteps(new String[]{propertyKey}, (PropertyFetcher)propertyFetcher);
                            }
                        });
                    }
                });
            }
        });
        TraversalHelper.getStepsOfClass(DedupGlobalStep.class, traversal).forEach(dedupGlobalStep -> {
            Collection<PropertyFetcher> propertyFetchers = this.getPropertyFetcherStepOf((Step)dedupGlobalStep, traversal);
            if (propertyFetchers != null) {
                propertyFetchers.forEach(propertyFetcher -> {
                    if (traversal.getParent() instanceof ConnectiveStep || TraversalHelper.hasStepOfClass(MatchStep.MatchStartStep.class, (Traversal.Admin)traversal)) {
                        propertyFetcher.fetchAllKeys();
                    } else if (dedupGlobalStep.getLocalChildren().size() > 0 && dedupGlobalStep.getLocalChildren().get(0) instanceof ElementValueTraversal) {
                        String propertyKey = ((ElementValueTraversal)dedupGlobalStep.getLocalChildren().get(0)).getPropertyKey();
                        this.handlePropertiesSteps(new String[]{propertyKey}, (PropertyFetcher)propertyFetcher);
                    }
                });
            }
        });
        TraversalHelper.getStepsOfClass(PropertyMapStep.class, traversal).forEach(propertyMapStep -> {
            Collection<PropertyFetcher> propertyFetchers = this.getPropertyFetcherStepOf((Step)propertyMapStep, traversal);
            if (propertyFetchers != null) {
                propertyFetchers.forEach(propertyFetcher -> {
                    if (traversal.getParent() instanceof ConnectiveStep || TraversalHelper.hasStepOfClass(MatchStep.MatchStartStep.class, (Traversal.Admin)traversal)) {
                        propertyFetcher.fetchAllKeys();
                    } else {
                        this.handlePropertiesSteps(propertyMapStep.getPropertyKeys(), (PropertyFetcher)propertyFetcher);
                    }
                });
            }
        });
        TraversalHelper.getStepsOfClass(PropertiesStep.class, traversal).forEach(propertiesStep -> {
            Collection<PropertyFetcher> propertyFetchers = this.getPropertyFetcherStepOf((Step)propertiesStep, traversal);
            if (propertyFetchers != null) {
                propertyFetchers.forEach(propertyFetcher -> {
                    if (traversal.getParent() instanceof ConnectiveStep || TraversalHelper.hasStepOfClass(MatchStep.MatchStartStep.class, (Traversal.Admin)traversal)) {
                        propertyFetcher.fetchAllKeys();
                    } else {
                        this.handlePropertiesSteps(propertiesStep.getPropertyKeys(), (PropertyFetcher)propertyFetcher);
                    }
                });
            }
        });
        TraversalHelper.getStepsOfClass(HasStep.class, traversal).forEach(hasStep -> {
            Collection<PropertyFetcher> propertyFetchers = this.getPropertyFetcherStepOf((Step)hasStep, traversal);
            if (propertyFetchers != null) {
                propertyFetchers.forEach(propertyFetcher -> {
                    if (traversal.getParent() instanceof ConnectiveStep || TraversalHelper.hasStepOfClass(MatchStep.MatchStartStep.class, (Traversal.Admin)traversal)) {
                        propertyFetcher.fetchAllKeys();
                    } else {
                        List hasContainers = hasStep.getHasContainers();
                        hasContainers.stream().map(HasContainer::getKey).forEach(propertyFetcher::addPropertyKey);
                    }
                });
            }
        });
        TraversalHelper.getStepsOfClass(WherePredicateStep.class, traversal).forEach(wherePredicateStep -> {
            Collection<PropertyFetcher> propertyFetchers = this.getPropertyFetcherStepOf((Step)wherePredicateStep, traversal);
            if (propertyFetchers != null) {
                propertyFetchers.forEach(PropertyFetcher::fetchAllKeys);
            } else {
                String possibleLabel = ((P)wherePredicateStep.getPredicate().get()).getValue().toString();
                traversal.getSteps().forEach(step -> {
                    if (step.getLabels().contains(possibleLabel)) {
                        if (step instanceof PropertyFetcher) {
                            ((PropertyFetcher)step).fetchAllKeys();
                        } else {
                            Collection<PropertyFetcher> propertyFetcherStepOf = this.getPropertyFetcherStepOf((Step)step, traversal);
                            if (propertyFetcherStepOf != null) {
                                propertyFetcherStepOf.forEach(PropertyFetcher::fetchAllKeys);
                            }
                        }
                    }
                });
            }
        });
        TraversalHelper.getStepsOfAssignableClass(FilterStep.class, traversal).forEach(filterStep -> {
            Collection<PropertyFetcher> propertyFetchers = this.getPropertyFetcherStepOf((Step)filterStep, traversal);
            if (!(filterStep instanceof HasStep || filterStep instanceof WherePredicateStep || filterStep instanceof DedupGlobalStep || filterStep instanceof RangeGlobalStep || propertyFetchers == null)) {
                propertyFetchers.forEach(PropertyFetcher::fetchAllKeys);
            }
        });
        TraversalHelper.getStepsOfClass(PathStep.class, traversal).forEach(pathStep -> {
            List<PropertyFetcher> propertyFetchers = this.getAllPropertyFetchersOf((Step)pathStep, traversal);
            pathStep.getLocalChildren().forEach(t -> {
                if (t instanceof ElementValueTraversal) {
                    String propertyKey = ((ElementValueTraversal)t).getPropertyKey();
                    propertyFetchers.forEach(propertyFetcher -> this.handlePropertiesSteps(new String[]{propertyKey}, (PropertyFetcher)propertyFetcher));
                }
            });
        });
        TraversalHelper.getStepsOfClass(TreeStep.class, traversal).forEach(treeStep -> {
            List<PropertyFetcher> propertyFetchers = this.getAllPropertyFetchersOf((Step)treeStep, traversal);
            treeStep.getLocalChildren().forEach(t -> {
                if (t instanceof ElementValueTraversal) {
                    String propertyKey = ((ElementValueTraversal)t).getPropertyKey();
                    propertyFetchers.forEach(propertyFetcher -> this.handlePropertiesSteps(new String[]{propertyKey}, (PropertyFetcher)propertyFetcher));
                }
            });
        });
        TraversalHelper.getStepsOfClass(TreeSideEffectStep.class, traversal).forEach(treeStep -> {
            List<PropertyFetcher> propertyFetchers = this.getAllPropertyFetchersOf((Step)treeStep, traversal);
            treeStep.getLocalChildren().forEach(t -> {
                if (t instanceof ElementValueTraversal) {
                    String propertyKey = ((ElementValueTraversal)t).getPropertyKey();
                    propertyFetchers.forEach(propertyFetcher -> this.handlePropertiesSteps(new String[]{propertyKey}, (PropertyFetcher)propertyFetcher));
                }
            });
        });
        TraversalHelper.getStepsOfAssignableClass(MapStep.class, traversal).forEach(mapStep -> {
            Collection<PropertyFetcher> propertyFetchers = this.getPropertyFetcherStepOf((Step)mapStep, traversal);
            if (!(mapStep instanceof PropertyMapStep || mapStep instanceof SelectOneStep || mapStep instanceof PathStep || propertyFetchers == null)) {
                propertyFetchers.forEach(PropertyFetcher::fetchAllKeys);
            }
        });
        TraversalHelper.getStepsOfAssignableClass(GroupStep.class, traversal).forEach(groupStep -> {
            Collection<PropertyFetcher> propertyFetchers = this.getPropertyFetcherStepOf((Step)groupStep, traversal);
            groupStep.getLocalChildren().forEach(t -> {
                if (propertyFetchers != null) {
                    propertyFetchers.forEach(propertyFetcher -> {
                        if (t instanceof ElementValueTraversal) {
                            String propertyKey = ((ElementValueTraversal)t).getPropertyKey();
                            this.handlePropertiesSteps(new String[]{propertyKey}, (PropertyFetcher)propertyFetcher);
                        } else if (t instanceof DefaultGraphTraversal) {
                            List steps = ((DefaultGraphTraversal)t).getSteps();
                            steps.forEach(step -> {
                                if (step instanceof TraversalMapStep) {
                                    ((TraversalMapStep)step).getLocalChildren().forEach(t2 -> {
                                        if (t2 instanceof ElementValueTraversal) {
                                            String propertyKey = ((ElementValueTraversal)t2).getPropertyKey();
                                            this.handlePropertiesSteps(new String[]{propertyKey}, (PropertyFetcher)propertyFetcher);
                                        }
                                    });
                                } else if (step instanceof PropertiesStep) {
                                    String[] propertyKeys = ((PropertiesStep)step).getPropertyKeys();
                                    if (propertyKeys.length == 0) {
                                        propertyFetcher.fetchAllKeys();
                                    } else {
                                        for (String propertyKey : propertyKeys) {
                                            propertyFetcher.addPropertyKey(propertyKey);
                                        }
                                    }
                                }
                            });
                        }
                    });
                }
            });
        });
        TraversalHelper.getStepsOfAssignableClass(GroupCountStep.class, traversal).forEach(groupCountStep -> {
            Collection<PropertyFetcher> propertyFetchers = this.getPropertyFetcherStepOf((Step)groupCountStep, traversal);
            groupCountStep.getLocalChildren().forEach(t -> {
                if (t instanceof ElementValueTraversal) {
                    String propertyKey = ((ElementValueTraversal)t).getPropertyKey();
                    propertyFetchers.forEach(propertyFetcher -> this.handlePropertiesSteps(new String[]{propertyKey}, (PropertyFetcher)propertyFetcher));
                }
            });
        });
        TraversalHelper.getStepsOfAssignableClass(ReducingBarrierStep.class, traversal).forEach(reducingBarrierStep -> {
            Collection<PropertyFetcher> propertyFetchers = this.getPropertyFetcherStepOf((Step)reducingBarrierStep, traversal);
            if (!(reducingBarrierStep instanceof FoldStep || reducingBarrierStep instanceof GroupStep || reducingBarrierStep instanceof GroupCountStep || reducingBarrierStep instanceof TreeStep || propertyFetchers == null)) {
                propertyFetchers.forEach(PropertyFetcher::fetchAllKeys);
            }
        });
        TraversalHelper.getStepsOfAssignableClass(SideEffectStep.class, traversal).forEach(sideEffectStep -> {
            Collection<PropertyFetcher> propertyFetchers = this.getPropertyFetcherStepOf((Step)sideEffectStep, traversal);
            if (propertyFetchers != null) {
                propertyFetchers.forEach(PropertyFetcher::fetchAllKeys);
            }
        });
        TraversalHelper.getStepsOfAssignableClass(SelectOneStep.class, traversal).forEach(selectOneStep -> {
            List<PropertyFetcher> allPropertyFetchersOf = this.getAllPropertyFetchersOf((Step)selectOneStep, traversal);
            allPropertyFetchersOf.forEach(propertyFetcher -> {
                Set scopeKeys = selectOneStep.getScopeKeys();
                Set labels = ((Step)propertyFetcher).getLabels();
                Optional<String> first = labels.stream().filter(scopeKeys::contains).findFirst();
                if (first.isPresent()) {
                    propertyFetcher.fetchAllKeys();
                }
            });
        });
        TraversalHelper.getStepsOfAssignableClass(SelectStep.class, traversal).forEach(selectStep -> {
            List<PropertyFetcher> allPropertyFetchersOf;
            if (traversal.getParent().asStep() instanceof LocalStep) {
                Step localStep = traversal.getParent().asStep();
                allPropertyFetchersOf = this.getAllPropertyFetchersOf(localStep, traversal);
            } else {
                allPropertyFetchersOf = this.getAllPropertyFetchersOf((Step)selectStep, traversal);
            }
            allPropertyFetchersOf.forEach(propertyFetcher -> allPropertyFetchersOf.forEach(PropertyFetcher::fetchAllKeys));
        });
        TraversalHelper.getStepsOfAssignableClass(LambdaMapStep.class, traversal).forEach(lambdaMapStep -> {
            List<PropertyFetcher> allPropertyFetchersOf = this.getAllPropertyFetchersOf((Step)lambdaMapStep, traversal);
            if (allPropertyFetchersOf.size() > 0) {
                allPropertyFetchersOf.forEach(PropertyFetcher::fetchAllKeys);
            }
        });
        TraversalHelper.getStepsOfClass(OrderGlobalStep.class, traversal).forEach(orderGlobalStep -> orderGlobalStep.getLocalChildren().forEach(child -> TraversalHelper.getStepsOfAssignableClass(LambdaMapStep.class, (Traversal.Admin)((Traversal.Admin)child)).forEach(lambdaMapStep -> {
            Collection<PropertyFetcher> propertyFetcherStepsOf = this.getPropertyFetcherStepOf((Step)orderGlobalStep, traversal);
            if (propertyFetcherStepsOf != null) {
                propertyFetcherStepsOf.forEach(PropertyFetcher::fetchAllKeys);
            }
        })));
        TraversalHelper.getStepsOfAssignableClass(UniGraphRepeatStep.class, traversal).forEach(uniGraphRepeatStepTemp -> {
            Traversal.Admin repeatTraversal = uniGraphRepeatStepTemp.getRepeatTraversal();
            Optional lastStepOfAssignableClass = TraversalHelper.getLastStepOfAssignableClass(PropertyFetcher.class, repeatTraversal);
            if (lastStepOfAssignableClass.isPresent()) {
                ((PropertyFetcher)lastStepOfAssignableClass.get()).fetchAllKeys();
            }
        });
        TraversalHelper.getStepsOfAssignableClass(AddEdgeStep.class, traversal).forEach(addEdgeStep -> {
            List<PropertyFetcher> allPropertyFetchersOf = this.getAllPropertyFetchersOf((Step)addEdgeStep, traversal);
            if (allPropertyFetchersOf.size() > 0) {
                allPropertyFetchersOf.forEach(PropertyFetcher::fetchAllKeys);
            }
        });
        Optional lastStepOfAssignableClass = TraversalHelper.getLastStepOfAssignableClass(PropertyFetcher.class, traversal);
        if (lastStepOfAssignableClass.isPresent()) {
            ((PropertyFetcher)lastStepOfAssignableClass.get()).fetchAllKeys();
        }
        TraversalHelper.getStepsOfAssignableClass(UniGraphEdgeOtherVertexStep.class, traversal).forEach(uniGraphEdgeOtherVertexStep -> {
            Collection<PropertyFetcher> propertyFetcherStepsOf = this.getPropertyFetcherStepOf((Step)uniGraphEdgeOtherVertexStep, traversal);
            if (propertyFetcherStepsOf != null) {
                Set<String> keys = uniGraphEdgeOtherVertexStep.getKeys();
                propertyFetcherStepsOf.forEach(propertyFetcher -> {
                    if (keys != null) {
                        keys.forEach(propertyFetcher::addPropertyKey);
                    } else {
                        propertyFetcher.fetchAllKeys();
                    }
                });
            }
        });
        TraversalHelper.getStepsOfAssignableClass(UniGraphEdgeVertexStep.class, traversal).forEach(uniGraphEdgeVertexStep -> {
            Collection<PropertyFetcher> propertyFetcherStepsOf = this.getPropertyFetcherStepOf((Step)uniGraphEdgeVertexStep, traversal);
            if (propertyFetcherStepsOf != null) {
                Set<String> keys = uniGraphEdgeVertexStep.getKeys();
                propertyFetcherStepsOf.forEach(propertyFetcher -> {
                    if (keys != null) {
                        keys.forEach(propertyFetcher::addPropertyKey);
                    } else {
                        propertyFetcher.fetchAllKeys();
                    }
                });
            }
        });
        if (TraversalHelper.hasStepOfClass(WhereTraversalStep.class, traversal) || TraversalHelper.hasStepOfClass(UniGraphWhereTraversalStep.class, traversal)) {
            traversal.getSteps().forEach(step -> {
                if (step instanceof PropertyFetcher) {
                    ((PropertyFetcher)step).fetchAllKeys();
                }
            });
        }
    }

    private List<PropertyFetcher> getAllPropertyFetchersOf(Step step, Traversal.Admin<?, ?> traversal) {
        ArrayList<PropertyFetcher> propertyFetchers = new ArrayList<PropertyFetcher>();
        Step previous = step.getPreviousStep();
        while (!(previous instanceof EmptyStep)) {
            if (previous instanceof PropertyFetcher) {
                propertyFetchers.add((PropertyFetcher)previous);
            }
            if (previous instanceof TraversalParent) {
                ((TraversalParent)previous).getLocalChildren().forEach(t -> t.getSteps().stream().filter(s -> s instanceof PropertyFetcher).map(p -> (PropertyFetcher)p).forEach(propertyFetchers::add));
                ((TraversalParent)previous).getGlobalChildren().forEach(t -> t.getSteps().stream().filter(s -> s instanceof PropertyFetcher).map(p -> (PropertyFetcher)p).forEach(propertyFetchers::add));
            }
            previous = previous.getPreviousStep();
        }
        return propertyFetchers;
    }

    private Collection<PropertyFetcher> getPropertyFetcherStepOf(Step step, Traversal.Admin<?, ?> traversal) {
        Step previous = step.getPreviousStep();
        while (!(previous instanceof PropertyFetcher)) {
            if (previous instanceof DedupGlobalStep || previous instanceof OrderGlobalStep) {
                previous = previous.getPreviousStep();
                continue;
            }
            if (previous instanceof EmptyStep) {
                TraversalParent parent = traversal.getParent();
                List propertyFetchers = parent.getLocalChildren().stream().flatMap(child -> TraversalHelper.getStepsOfAssignableClassRecursively(PropertyFetcher.class, (Traversal.Admin)child).stream()).collect(Collectors.toList());
                if (propertyFetchers.size() > 0) {
                    previous = (Step)propertyFetchers.get(propertyFetchers.size() - 1);
                    continue;
                }
                return null;
            }
            if (previous instanceof TraversalParent) {
                List<PropertyFetcher> propertyFetchers = Stream.concat(((TraversalParent)previous).getLocalChildren().stream(), ((TraversalParent)previous).getGlobalChildren().stream()).flatMap(child -> TraversalHelper.getStepsOfAssignableClassRecursively(PropertyFetcher.class, (Traversal.Admin)child).stream()).collect(Collectors.toList());
                if (propertyFetchers.size() > 0) {
                    return propertyFetchers;
                }
                return null;
            }
            if (previous instanceof WhereTraversalStep.WhereStartStep) {
                return null;
            }
            previous = previous.getPreviousStep();
        }
        return Collections.singleton((PropertyFetcher)previous);
    }
}

