/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.process.repeat;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ComputerAwareStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ExpandableStepIterator;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.unipop.process.UniBulkStep;
import org.unipop.structure.UniGraph;

public class UniGraphRepeatStep<S>
extends UniBulkStep<S, S>
implements TraversalParent {
    private Traversal.Admin<S, S> repeatTraversal = null;
    private Traversal.Admin<S, ?> untilTraversal = null;
    private Traversal.Admin<S, ?> emitTraversal = null;
    public boolean untilFirst = false;
    public boolean emitFirst = false;
    private List<Traverser.Admin<S>> emits;
    private List<Traverser.Admin<S>> untils;

    public Set<TraverserRequirement> getRequirements() {
        Set requirements = this.getSelfAndChildRequirements(new TraverserRequirement[]{TraverserRequirement.BULK});
        if (requirements.contains(TraverserRequirement.SINGLE_LOOP)) {
            requirements.add(TraverserRequirement.NESTED_LOOP);
        }
        requirements.add(TraverserRequirement.SINGLE_LOOP);
        return requirements;
    }

    public UniGraphRepeatStep(RepeatStep repeatStep, Traversal.Admin traversal, UniGraph graph) {
        super(traversal, graph);
        this.emitFirst = repeatStep.emitFirst;
        this.untilFirst = repeatStep.untilFirst;
        repeatStep.getLabels().forEach(s -> this.addLabel(s.toString()));
        this.repeatTraversal = (Traversal.Admin)repeatStep.getGlobalChildren().get(0);
        if (repeatStep.getEmitTraversal() != null) {
            this.emitTraversal = this.integrateChild(repeatStep.getEmitTraversal());
        }
        if (repeatStep.getUntilTraversal() != null) {
            this.untilTraversal = this.integrateChild(repeatStep.getUntilTraversal());
        }
        this.emits = new ArrayList<Traverser.Admin<S>>();
        this.untils = new ArrayList<Traverser.Admin<S>>();
    }

    public final boolean doUntil(Traverser.Admin<S> traverser, boolean utilFirst) {
        return utilFirst == this.untilFirst && null != this.untilTraversal && TraversalUtil.test(traverser, this.untilTraversal);
    }

    public final boolean doEmit(Traverser.Admin<S> traverser, boolean emitFirst) {
        return emitFirst == this.emitFirst && null != this.emitTraversal && TraversalUtil.test(traverser, this.emitTraversal);
    }

    public String toString() {
        if (this.untilFirst && this.emitFirst) {
            return StringFactory.stepString((Step)this, (Object[])new Object[]{this.untilString(), this.emitString(), this.repeatTraversal});
        }
        if (this.emitFirst) {
            return StringFactory.stepString((Step)this, (Object[])new Object[]{this.emitString(), this.repeatTraversal, this.untilString()});
        }
        if (this.untilFirst) {
            return StringFactory.stepString((Step)this, (Object[])new Object[]{this.untilString(), this.repeatTraversal, this.emitString()});
        }
        return StringFactory.stepString((Step)this, (Object[])new Object[]{this.repeatTraversal, this.untilString(), this.emitString()});
    }

    private final String untilString() {
        return null == this.untilTraversal ? "until(false)" : "until(" + this.untilTraversal + ')';
    }

    private final String emitString() {
        return null == this.emitTraversal ? "emit(false)" : "emit(" + this.emitTraversal + ')';
    }

    @Override
    protected Iterator<Traverser.Admin<S>> process(List<Traverser.Admin<S>> traversers) {
        ExpandableStepIterator iterator = traversers.iterator();
        boolean lastIter = true;
        while (!this.repeatTraversal.getEndStep().hasNext()) {
            if (this.starts.hasNext()) {
                lastIter = true;
            }
            if (!lastIter) {
                if (this.emitFirst && this.untilFirst) {
                    return this.emits.iterator();
                }
                return Iterators.concat(this.emits.iterator(), this.untils.iterator());
            }
            lastIter = false;
            while (iterator.hasNext()) {
                Traverser.Admin<S> traverser = iterator.next();
                if (this.doUntil(traverser, true)) {
                    traverser.resetLoops();
                    this.untils.add(traverser);
                }
                this.repeatTraversal.addStart(traverser);
                if (!this.doEmit(traverser, true)) continue;
                Traverser.Admin emitSplit = traverser.split();
                emitSplit.resetLoops();
                this.emits.add(emitSplit);
            }
            if (!this.starts.hasNext()) continue;
            iterator = this.starts;
        }
        return Iterators.concat((Iterator)this.repeatTraversal.getEndStep(), this.emits.iterator());
    }

    public Traversal.Admin<S, S> getRepeatTraversal() {
        return this.repeatTraversal;
    }

    public Traversal.Admin<S, ?> getUntilTraversal() {
        return this.untilTraversal;
    }

    public Traversal.Admin<S, ?> getEmitTraversal() {
        return this.emitTraversal;
    }

    public List<Traversal.Admin<S, S>> getGlobalChildren() {
        return null == this.repeatTraversal ? Collections.emptyList() : Collections.singletonList(this.repeatTraversal);
    }

    public List<Traversal.Admin<S, ?>> getLocalChildren() {
        ArrayList list = new ArrayList();
        if (null != this.untilTraversal) {
            list.add(this.untilTraversal);
        }
        if (null != this.emitTraversal) {
            list.add(this.emitTraversal);
        }
        return list;
    }

    public static class RepeatEndStep<S>
    extends ComputerAwareStep<S, S> {
        UniGraphRepeatStep<S> repeatStep;

        public RepeatEndStep(Traversal.Admin traversal, UniGraphRepeatStep<S> repeatStep) {
            super(traversal);
            this.repeatStep = repeatStep;
        }

        protected Iterator<Traverser.Admin<S>> standardAlgorithm() throws NoSuchElementException {
            Traverser.Admin start;
            do {
                start = this.starts.next();
                start.incrLoops(this.getId());
                if (this.repeatStep.doUntil(start, false)) {
                    start.resetLoops();
                    return IteratorUtils.of((Object)start);
                }
                if (!this.repeatStep.untilFirst && !this.repeatStep.emitFirst) {
                    ((UniGraphRepeatStep)this.repeatStep).repeatTraversal.addStart(start);
                    continue;
                }
                this.repeatStep.addStart(start);
            } while (!this.repeatStep.doEmit(start, false));
            Traverser.Admin emitSplit = start.split();
            emitSplit.resetLoops();
            return IteratorUtils.of((Object)emitSplit);
        }

        protected Iterator<Traverser.Admin<S>> computerAlgorithm() throws NoSuchElementException {
            RepeatStep repeatStep = (RepeatStep)this.getTraversal().getParent();
            Traverser.Admin start = this.starts.next();
            start.incrLoops(repeatStep.getId());
            if (repeatStep.doUntil(start, false)) {
                start.resetLoops();
                start.setStepId(repeatStep.getNextStep().getId());
                start.addLabels(repeatStep.getLabels());
                return IteratorUtils.of((Object)start);
            }
            start.setStepId(repeatStep.getId());
            if (repeatStep.doEmit(start, false)) {
                Traverser.Admin emitSplit = start.split();
                emitSplit.resetLoops();
                emitSplit.setStepId(repeatStep.getNextStep().getId());
                return IteratorUtils.of((Object)start, (Object)emitSplit);
            }
            return IteratorUtils.of((Object)start);
        }
    }
}

