/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.process.vertex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.EmptyIterator;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unipop.process.UniPredicatesStep;
import org.unipop.process.order.Orderable;
import org.unipop.process.predicate.ReceivesPredicatesHolder;
import org.unipop.query.StepDescriptor;
import org.unipop.query.controller.ControllerManager;
import org.unipop.query.predicates.PredicatesHolder;
import org.unipop.query.predicates.PredicatesHolderFactory;
import org.unipop.query.search.DeferredVertexQuery;
import org.unipop.query.search.SearchVertexQuery;
import org.unipop.schema.reference.DeferredVertex;
import org.unipop.structure.UniGraph;
import org.unipop.structure.UniVertex;
import org.unipop.util.ConversionUtils;

public class UniGraphVertexStep<E extends Element>
extends UniPredicatesStep<Vertex, E>
implements ReceivesPredicatesHolder<Vertex, E>,
Orderable,
Profiling {
    private static final Logger logger = LoggerFactory.getLogger(UniGraphVertexStep.class);
    private final boolean returnsVertex;
    private final Direction direction;
    private Class<E> returnClass;
    private String[] edgeLabels = new String[0];
    private int limit;
    private PredicatesHolder predicates = PredicatesHolderFactory.empty();
    private StepDescriptor stepDescriptor;
    private List<SearchVertexQuery.SearchVertexController> controllers;
    private List<DeferredVertexQuery.DeferredVertexController> deferredVertexControllers;
    private List<Pair<String, Order>> orders;

    public UniGraphVertexStep(VertexStep<E> vertexStep, UniGraph graph, ControllerManager controllerManager) {
        super(vertexStep.getTraversal(), graph);
        vertexStep.getLabels().forEach(arg_0 -> ((UniGraphVertexStep)this).addLabel(arg_0));
        this.direction = vertexStep.getDirection();
        this.returnClass = vertexStep.getReturnClass();
        this.returnsVertex = vertexStep.returnsVertex();
        if (vertexStep.getEdgeLabels().length > 0) {
            this.edgeLabels = vertexStep.getEdgeLabels();
            HasContainer labelsPredicate = new HasContainer(T.label.getAccessor(), P.within((Object[])vertexStep.getEdgeLabels()));
            this.predicates = PredicatesHolderFactory.predicate(labelsPredicate);
        } else {
            this.predicates = PredicatesHolderFactory.empty();
        }
        this.controllers = controllerManager.getControllers(SearchVertexQuery.SearchVertexController.class);
        this.deferredVertexControllers = controllerManager.getControllers(DeferredVertexQuery.DeferredVertexController.class);
        this.stepDescriptor = new StepDescriptor(this);
        this.limit = -1;
    }

    @Override
    protected Iterator<Traverser.Admin<E>> process(List<Traverser.Admin<Vertex>> traversers) {
        HashMap idToTraverser = new HashMap(traversers.size());
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(traversers.size());
        traversers.forEach(traverser -> {
            Vertex vertex = (Vertex)traverser.get();
            ArrayList<Traverser.Admin> traverserList = (ArrayList<Traverser.Admin>)idToTraverser.get(vertex.id());
            if (traverserList == null) {
                traverserList = new ArrayList<Traverser.Admin>(1);
                idToTraverser.put(vertex.id(), traverserList);
            }
            traverserList.add((Traverser.Admin)traverser);
            vertices.add(vertex);
        });
        SearchVertexQuery vertexQuery = !this.returnsVertex ? new SearchVertexQuery(Edge.class, vertices, this.direction, this.predicates, this.limit, this.propertyKeys, this.orders, this.stepDescriptor) : new SearchVertexQuery(Edge.class, vertices, this.direction, this.predicates, -1, this.propertyKeys, null, this.stepDescriptor);
        logger.debug("Executing query: ", (Object)vertexQuery);
        Iterator<Traverser.Admin<E>> traversersIterator = this.controllers.stream().map(controller -> controller.search(vertexQuery)).flatMap(ConversionUtils::asStream).flatMap(edge -> this.toTraversers((Edge)edge, idToTraverser)).iterator();
        if (!this.returnsVertex || this.propertyKeys != null && this.propertyKeys.size() == 0) {
            return traversersIterator;
        }
        return this.getTraversersWithProperties(traversersIterator);
    }

    private Iterator<Traverser.Admin<E>> getTraversersWithProperties(Iterator<Traverser.Admin<E>> traversers) {
        List copyTraversers = ConversionUtils.asStream(traversers).collect(Collectors.toList());
        List<DeferredVertex> deferredVertices = copyTraversers.stream().map(Attachable::get).filter(vertex -> vertex instanceof DeferredVertex).map(vertex -> (DeferredVertex)vertex).filter(DeferredVertex::isDeferred).collect(Collectors.toList());
        if (deferredVertices.size() > 0) {
            DeferredVertexQuery query = new DeferredVertexQuery(deferredVertices, this.propertyKeys, this.orders, this.stepDescriptor);
            this.deferredVertexControllers.stream().forEach(controller -> controller.fetchProperties(query));
        }
        return copyTraversers.iterator();
    }

    private Stream<Traverser.Admin<E>> toTraversers(Edge edge, Map<Object, List<Traverser<Vertex>>> traversers) {
        return ConversionUtils.asStream(edge.vertices(this.direction)).flatMap(originalVertex -> {
            List vertexTraversers = (List)traversers.get(originalVertex.id());
            if (vertexTraversers == null) {
                return null;
            }
            return vertexTraversers.stream().map(vertexTraverser -> {
                E result = this.getReturnElement(edge, (Vertex)originalVertex);
                return vertexTraverser.asAdmin().split(result, (Step)this);
            });
        }).filter(result -> result != null);
    }

    private E getReturnElement(Edge edge, Vertex originalVertex) {
        if (!this.returnsVertex) {
            return (E)edge;
        }
        return (E)UniVertex.vertexToVertex(originalVertex, edge, this.direction);
    }

    @Override
    public void reset() {
        super.reset();
        this.results = EmptyIterator.instance();
    }

    public String toString() {
        return StringFactory.stepString((Step)this, (Object[])new Object[]{this.direction, Arrays.asList(this.edgeLabels), this.returnClass.getSimpleName().toLowerCase()});
    }

    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public void addPredicate(PredicatesHolder predicatesHolder) {
        this.predicates = PredicatesHolderFactory.and(this.predicates, predicatesHolder);
    }

    @Override
    public PredicatesHolder getPredicates() {
        return this.predicates;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setMetrics(MutableMetrics metrics) {
        this.stepDescriptor = new StepDescriptor(this, metrics);
    }

    @Override
    public void setOrders(List<Pair<String, Order>> orders) {
        this.orders = orders;
    }

    @Override
    public void addPropertyKey(String key) {
        if (!this.returnsVertex) {
            super.addPropertyKey(key);
        } else {
            super.fetchAllKeys();
        }
    }
}

