/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.query.controller;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.json.JSONObject;
import org.unipop.query.controller.ControllerManager;
import org.unipop.query.controller.SourceProvider;
import org.unipop.query.controller.UniQueryController;
import org.unipop.schema.property.PropertySchema;
import org.unipop.structure.UniGraph;
import org.unipop.util.DirectoryWatcher;
import org.unipop.util.PropertySchemaFactory;

public class ConfigurationControllerManager
implements ControllerManager {
    protected Set<SourceProvider> sourceProviders = new HashSet<SourceProvider>();
    protected Set<UniQueryController> controllers = new HashSet<UniQueryController>();
    protected DirectoryWatcher watcher;
    protected Path path;
    protected UniGraph graph;
    protected List<PropertySchema.PropertySchemaBuilder> thirdPartyPropertySchemas;

    public ConfigurationControllerManager(UniGraph graph, Configuration configuration, List<PropertySchema.PropertySchemaBuilder> thirdPartyPropertySchemas) throws Exception {
        this.path = Paths.get(configuration.getString("providers"), new String[0]);
        this.graph = graph;
        this.thirdPartyPropertySchemas = thirdPartyPropertySchemas;
        this.watcher = new DirectoryWatcher(this.path, configuration.getInt("controllerManager.interval", 10000), newPath -> this.loadControllers());
        this.loadControllers();
        this.watcher.start();
    }

    private void loadControllers() throws IOException {
        this.controllers.clear();
        this.sourceProviders.forEach(SourceProvider::close);
        this.sourceProviders.clear();
        Files.walk(this.path, new FileVisitOption[0]).forEach(filePath -> {
            if (Files.isRegularFile(filePath, new LinkOption[0])) {
                String providerJson = ConfigurationControllerManager.readFile(filePath.toAbsolutePath().toString());
                JSONObject providerConfig = new JSONObject(providerJson);
                String providerClass = providerConfig.getString("class");
                SourceProvider sourceProvider = null;
                try {
                    sourceProvider = Class.forName(providerClass).asSubclass(SourceProvider.class).newInstance();
                    PropertySchemaFactory.build(sourceProvider.providerBuilders(), this.thirdPartyPropertySchemas);
                    Set<UniQueryController> controllers = sourceProvider.init(this.graph, providerConfig);
                    this.controllers.addAll(controllers);
                    this.sourceProviders.add(sourceProvider);
                }
                catch (Exception e) {
                    throw new RuntimeException("class: " + providerClass + " not found");
                }
            }
        });
    }

    private static String readFile(String filename) {
        String result = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(filename));
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
            result = sb.toString();
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Set<UniQueryController> getControllers() {
        return this.controllers;
    }

    @Override
    public void close() {
        this.sourceProviders.forEach(SourceProvider::close);
        try {
            this.watcher.stop();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "ConfigurationControllerManager{controllers=" + this.controllers + ", sourceProviders=" + this.sourceProviders + '}';
    }
}

