/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.query.predicates;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;

public class PredicatesHolder {
    private Clause clause;
    private List<HasContainer> predicates;
    private List<PredicatesHolder> children;

    public PredicatesHolder(Clause clause, List<HasContainer> predicates, List<PredicatesHolder> children) {
        this.clause = clause;
        this.predicates = predicates != null ? predicates : Collections.emptyList();
        this.children = children != null ? children : Collections.emptyList();
    }

    public Clause getClause() {
        return this.clause;
    }

    public List<HasContainer> getPredicates() {
        return this.predicates;
    }

    public List<PredicatesHolder> getChildren() {
        return this.children;
    }

    public boolean hasPredicates() {
        return this.getPredicates().size() > 0;
    }

    public boolean hasChildren() {
        return this.getChildren().size() > 0;
    }

    public boolean isEmpty() {
        return !this.hasPredicates() && !this.hasChildren();
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    public boolean isAborted() {
        return this.clause.equals((Object)Clause.Abort);
    }

    public boolean notAborted() {
        return !this.isAborted();
    }

    public Stream<HasContainer> findKey(String key) {
        return this.predicates.stream().filter(has -> has.getKey().equals(key));
    }

    public PredicatesHolder map(Function<HasContainer, HasContainer> func) {
        List<HasContainer> predicates = this.getPredicates().stream().map(func).collect(Collectors.toList());
        List<PredicatesHolder> children = this.getChildren().stream().map((? super T child) -> child.map(func)).collect(Collectors.toList());
        return new PredicatesHolder(this.getClause(), predicates, children);
    }

    public static enum Clause {
        And,
        Or,
        Abort;

    }
}

