/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.query.predicates;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.unipop.query.predicates.PredicatesHolder;

public class PredicatesHolderFactory {
    public static PredicatesHolder abort() {
        return new PredicatesHolder(PredicatesHolder.Clause.Abort, null, null);
    }

    public static PredicatesHolder empty() {
        return new PredicatesHolder(PredicatesHolder.Clause.And, null, null);
    }

    public static PredicatesHolder predicate(HasContainer predicate) {
        return PredicatesHolderFactory.and(predicate);
    }

    public static PredicatesHolder and(HasContainer ... predicates) {
        return new PredicatesHolder(PredicatesHolder.Clause.And, Arrays.asList(predicates), null);
    }

    public static PredicatesHolder and(PredicatesHolder ... predicatesHolders) {
        return PredicatesHolderFactory.and(Sets.newHashSet((Object[])predicatesHolders));
    }

    public static PredicatesHolder and(Set<PredicatesHolder> predicatesHolders) {
        if (predicatesHolders.stream().filter(PredicatesHolder::isAborted).count() > 0L) {
            return PredicatesHolderFactory.abort();
        }
        Set filteredPredicateHolders = predicatesHolders.stream().filter(PredicatesHolder::notEmpty).collect(Collectors.toSet());
        if (filteredPredicateHolders.size() == 0) {
            return PredicatesHolderFactory.empty();
        }
        if (filteredPredicateHolders.size() == 1) {
            return (PredicatesHolder)filteredPredicateHolders.iterator().next();
        }
        ArrayList<HasContainer> predicates = new ArrayList<HasContainer>();
        ArrayList<PredicatesHolder> children = new ArrayList<PredicatesHolder>();
        for (PredicatesHolder predicatesHolder : filteredPredicateHolders) {
            if (predicatesHolder.getClause().equals((Object)PredicatesHolder.Clause.And)) {
                predicates.addAll(predicatesHolder.getPredicates());
                children.addAll(predicatesHolder.getChildren());
                continue;
            }
            children.add(predicatesHolder);
        }
        return new PredicatesHolder(PredicatesHolder.Clause.And, predicates, children);
    }

    public static PredicatesHolder or(HasContainer ... predicates) {
        return new PredicatesHolder(PredicatesHolder.Clause.Or, Arrays.asList(predicates), null);
    }

    public static PredicatesHolder or(PredicatesHolder ... predicatesHolders) {
        return PredicatesHolderFactory.or(Sets.newHashSet((Object[])predicatesHolders));
    }

    public static PredicatesHolder or(Collection<PredicatesHolder> predicatesHolders) {
        if (predicatesHolders.size() == 0) {
            return PredicatesHolderFactory.empty();
        }
        List<PredicatesHolder> filteredPredicateHolders = predicatesHolders.stream().filter(p -> p != null).filter(PredicatesHolder::notAborted).collect(Collectors.toList());
        if (filteredPredicateHolders.size() == 0) {
            return PredicatesHolderFactory.abort();
        }
        if (filteredPredicateHolders.size() == 1) {
            return (PredicatesHolder)filteredPredicateHolders.iterator().next();
        }
        return new PredicatesHolder(PredicatesHolder.Clause.Or, Collections.EMPTY_LIST, filteredPredicateHolders);
    }

    public static PredicatesHolder create(PredicatesHolder.Clause clause, Set<PredicatesHolder> predicatesHolders) {
        if (clause.equals((Object)PredicatesHolder.Clause.And)) {
            return PredicatesHolderFactory.and(predicatesHolders);
        }
        if (clause.equals((Object)PredicatesHolder.Clause.Or)) {
            return PredicatesHolderFactory.or(predicatesHolders);
        }
        return PredicatesHolderFactory.abort();
    }

    public static PredicatesHolder createFromPredicates(PredicatesHolder.Clause clause, Set<HasContainer> predicatesHolders) {
        return new PredicatesHolder(clause, new ArrayList<HasContainer>(predicatesHolders), null);
    }
}

