/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.query.search;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.javatuples.Pair;
import org.unipop.query.StepDescriptor;
import org.unipop.query.VertexQuery;
import org.unipop.query.controller.UniQueryController;
import org.unipop.query.predicates.PredicatesHolder;
import org.unipop.query.search.SearchQuery;

public class SearchVertexQuery
extends SearchQuery<Edge>
implements VertexQuery {
    private final List<Vertex> vertices;
    private final Direction direction;

    public SearchVertexQuery(Class<Edge> returnType, List<Vertex> vertices, Direction direction, PredicatesHolder predicates, int limit, Set<String> propertyKeys, List<Pair<String, Order>> orders, StepDescriptor stepDescriptor) {
        super(returnType, predicates, limit, propertyKeys, orders, stepDescriptor);
        this.vertices = vertices;
        this.direction = direction;
    }

    @Override
    public List<Vertex> getVertices() {
        return this.vertices;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public boolean test(Edge element, PredicatesHolder predicates) {
        boolean edgePredicates = super.test(element, predicates);
        if (!edgePredicates) {
            return false;
        }
        if ((this.direction.equals((Object)Direction.OUT) || this.direction.equals((Object)Direction.BOTH)) && this.vertices.contains(element.outVertex())) {
            return true;
        }
        return (this.direction.equals((Object)Direction.IN) || this.direction.equals((Object)Direction.BOTH)) && this.vertices.contains(element.inVertex());
    }

    @Override
    public String toString() {
        return "SearchVertexQuery{vertices=" + this.vertices + ", direction=" + this.direction + '}';
    }

    public static interface SearchVertexController
    extends UniQueryController {
        public Iterator<Edge> search(SearchVertexQuery var1);
    }
}

