/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.schema.element;

import java.util.HashSet;
import java.util.Set;
import org.unipop.schema.element.ElementSchema;

public class SchemaSet {
    Set<ElementSchema> schemas = new HashSet<ElementSchema>();

    public void add(ElementSchema schema) {
        this.schemas.add(schema);
    }

    public Set<ElementSchema> get(Boolean recursive) {
        if (!recursive.booleanValue()) {
            return this.schemas;
        }
        HashSet<ElementSchema> result = new HashSet<ElementSchema>();
        this.addRecursive(result, this.schemas);
        return result;
    }

    private void addRecursive(Set<ElementSchema> result, Set<ElementSchema> schemas) {
        schemas.forEach(schema -> {
            if (result.contains(schema)) {
                return;
            }
            result.add((ElementSchema)schema);
            Set<ElementSchema> childSchemas = schema.getChildSchemas();
            this.addRecursive(result, childSchemas);
        });
    }

    public <T extends ElementSchema> Set<T> get(Class<? extends T> c, Boolean recursive) {
        HashSet result = new HashSet();
        this.get(recursive).forEach(schema -> {
            if (c.isAssignableFrom(schema.getClass())) {
                result.add(schema);
            }
        });
        return result;
    }
}

