/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.schema.element;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.unipop.query.predicates.PredicatesHolder;
import org.unipop.query.predicates.PredicatesHolderFactory;
import org.unipop.schema.element.ElementSchema;

public interface VertexSchema
extends ElementSchema<Vertex> {
    @Override
    default public Collection<Vertex> fromFields(Map<String, Object> fields) {
        Vertex element = this.createElement(fields);
        if (element == null) {
            return null;
        }
        return Collections.singleton(element);
    }

    public Vertex createElement(Map<String, Object> var1);

    default public PredicatesHolder toPredicates(List<? extends Vertex> vertices) {
        if (vertices == null || vertices.size() == 0) {
            return PredicatesHolderFactory.abort();
        }
        HashSet<PredicatesHolder> predicates = new HashSet<PredicatesHolder>();
        vertices.stream().collect(Collectors.groupingBy(Element::label)).forEach((label, labelVertices) -> {
            HasContainer labelPredicate = new HasContainer(T.label.getAccessor(), P.eq((Object)label));
            HasContainer ids = new HasContainer(T.id.getAccessor(), P.within((Collection)labelVertices.stream().map(Element::id).collect(Collectors.toSet())));
            PredicatesHolder labelPredicates = PredicatesHolderFactory.and(ids, labelPredicate);
            PredicatesHolder toPredicates = this.toPredicates(labelPredicates);
            predicates.add(toPredicates);
        });
        return PredicatesHolderFactory.or(predicates);
    }
}

