/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.schema.property;

import java.util.ArrayList;
import java.util.List;
import org.apache.tinkerpop.gremlin.structure.T;
import org.json.JSONObject;
import org.unipop.schema.property.DynamicPropertySchema;
import org.unipop.schema.property.NonDynamicPropertySchema;
import org.unipop.schema.property.PropertySchema;
import org.unipop.structure.UniGraph;
import org.unipop.util.PropertySchemaFactory;

public abstract class AbstractPropertyContainer {
    protected final UniGraph graph;
    protected final JSONObject json;
    protected ArrayList<PropertySchema> propertySchemas = new ArrayList();
    protected DynamicPropertySchema dynamicProperties;

    public AbstractPropertyContainer(JSONObject json, UniGraph graph) {
        this.json = json;
        this.graph = graph;
        this.createPropertySchemas();
    }

    public List<PropertySchema> getPropertySchemas() {
        return this.propertySchemas;
    }

    protected void createPropertySchemas() {
        Object dynamicPropertiesConfig;
        this.addPropertySchema(T.id.getAccessor(), this.json.get(T.id.toString()));
        this.addPropertySchema(T.label.getAccessor(), this.json.get(T.label.toString()));
        JSONObject properties = this.json.optJSONObject("properties");
        if (properties != null) {
            properties.keys().forEachRemaining(key -> this.addPropertySchema((String)key, properties.get(key)));
        }
        this.dynamicProperties = (dynamicPropertiesConfig = this.json.opt("dynamicProperties")) instanceof Boolean && (Boolean)dynamicPropertiesConfig != false ? new DynamicPropertySchema(this.propertySchemas) : (dynamicPropertiesConfig instanceof JSONObject ? new DynamicPropertySchema(this.propertySchemas, (JSONObject)dynamicPropertiesConfig) : new NonDynamicPropertySchema(this.propertySchemas));
        this.propertySchemas.add(this.dynamicProperties);
    }

    protected void addPropertySchema(String key, Object value) {
        PropertySchema propertySchema = PropertySchemaFactory.createPropertySchema(key, value, this);
        this.propertySchemas.add(propertySchema);
    }

    public String toString() {
        return "AbstractPropertyContainer{dynamicProperties=" + this.dynamicProperties + ", graph=" + this.graph + ", propertySchemas=" + this.propertySchemas + '}';
    }
}

