/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.schema.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.unipop.query.predicates.PredicatesHolder;
import org.unipop.query.predicates.PredicatesHolderFactory;
import org.unipop.schema.property.AbstractPropertyContainer;
import org.unipop.schema.property.ParentSchemaProperty;
import org.unipop.schema.property.PropertySchema;
import org.unipop.util.PropertySchemaFactory;

public class CoalescePropertySchema
implements ParentSchemaProperty {
    protected final String key;
    protected final List<PropertySchema> children;

    public CoalescePropertySchema(String key, List<PropertySchema> schemas) {
        this.key = key;
        this.children = schemas;
    }

    @Override
    public Collection<PropertySchema> getChildren() {
        return this.children;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Map<String, Object> toProperties(Map<String, Object> source) {
        Optional<Map> first = this.children.stream().map(schema -> schema.toProperties(source)).filter(prop -> !prop.equals(Collections.emptyMap())).findFirst();
        if (!first.isPresent()) {
            return Collections.singletonMap(this.key, "null");
        }
        return first.get();
    }

    @Override
    public Set<Object> getValues(PredicatesHolder predicatesHolder) {
        return null;
    }

    @Override
    public PredicatesHolder toPredicate(HasContainer hasContainer) {
        HashSet<PredicatesHolder> predicates = new HashSet<PredicatesHolder>();
        this.children.forEach(schema -> predicates.add(schema.toPredicate(hasContainer)));
        return PredicatesHolderFactory.or(predicates);
    }

    public static class Builder
    implements PropertySchema.PropertySchemaBuilder {
        @Override
        public PropertySchema build(String key, Object conf, AbstractPropertyContainer container) {
            if (!(conf instanceof JSONObject)) {
                return null;
            }
            JSONObject config = (JSONObject)conf;
            Object obj = config.opt("fields");
            if (obj == null || !(obj instanceof JSONArray)) {
                return null;
            }
            if (!config.optString("type", "String").toUpperCase().equals("COALESCE")) {
                return null;
            }
            JSONArray fieldsArray = (JSONArray)obj;
            ArrayList<PropertySchema> schemas = new ArrayList<PropertySchema>();
            for (int i = 0; i < fieldsArray.length(); ++i) {
                Object field = fieldsArray.get(i);
                schemas.add(PropertySchemaFactory.createPropertySchema(key, field, container));
            }
            return new CoalescePropertySchema(key, schemas);
        }
    }
}

