/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.schema.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.unipop.query.predicates.PredicatesHolder;
import org.unipop.query.predicates.PredicatesHolderFactory;
import org.unipop.schema.property.AbstractPropertyContainer;
import org.unipop.schema.property.ParentSchemaProperty;
import org.unipop.schema.property.PropertySchema;
import org.unipop.util.PropertySchemaFactory;

public class ConcatenateFieldPropertySchema
implements ParentSchemaProperty {
    private final String key;
    private final List<PropertySchema> schemas;
    private String delimiter;

    public ConcatenateFieldPropertySchema(String key, List<PropertySchema> schemas, String delimiter, boolean nullable) {
        this.key = key;
        this.schemas = schemas;
        this.delimiter = delimiter;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Map<String, Object> toProperties(Map<String, Object> source) {
        StringJoiner values = new StringJoiner(this.delimiter);
        for (PropertySchema schema : this.schemas) {
            Map<String, Object> props = schema.toProperties(source);
            if (props == null) {
                values.add("null");
                continue;
            }
            if (props.size() == 0) {
                return Collections.emptyMap();
            }
            props.values().stream().map(Object::toString).forEach(values::add);
        }
        return Collections.singletonMap(this.key, values.toString());
    }

    @Override
    public Collection<PropertySchema> getChildren() {
        return this.schemas;
    }

    @Override
    public Set<String> excludeDynamicFields() {
        return this.schemas.stream().map(PropertySchema::excludeDynamicFields).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Set<String> excludeDynamicProperties() {
        return Collections.singleton(this.key);
    }

    @Override
    public Map<String, Object> toFields(Map<String, Object> properties) {
        return Collections.emptyMap();
    }

    @Override
    public Set<String> toFields(Set<String> propertyKeys) {
        return this.schemas.stream().flatMap(s -> s.toFields(propertyKeys).stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<Object> getValues(PredicatesHolder predicatesHolder) {
        StringJoiner values = new StringJoiner(this.delimiter);
        for (PropertySchema schema : this.schemas) {
            Set<Object> schemaValues = schema.getValues(predicatesHolder);
            if (schemaValues == null || schemaValues.size() == 0) {
                return Collections.emptySet();
            }
            schemaValues.forEach(value -> values.add(value.toString()));
        }
        return Collections.singleton(values.toString());
    }

    private PredicatesHolder stringValueToPredicate(String value, HasContainer has, boolean collection) {
        String[] values = value.split(this.delimiter);
        if (values.length < this.schemas.size()) {
            return PredicatesHolderFactory.abort();
        }
        HashSet<PredicatesHolder> predicates = new HashSet<PredicatesHolder>();
        for (int i = 0; i < this.schemas.size(); ++i) {
            P predicate = has.getPredicate().clone();
            String currentValue = values[i];
            P p = new P(predicate.getBiPredicate(), collection ? Arrays.asList(currentValue) : currentValue);
            PredicatesHolder predicatesHolder = this.schemas.get(i).toPredicates(PredicatesHolderFactory.predicate(new HasContainer(has.getKey(), p)));
            predicates.add(predicatesHolder);
        }
        return PredicatesHolderFactory.and(predicates);
    }

    @Override
    public PredicatesHolder toPredicate(HasContainer has) {
        Object value = has.getValue();
        HashSet<PredicatesHolder> predicates = new HashSet<PredicatesHolder>();
        if (value instanceof String) {
            String valueString = value.toString();
            predicates.add(this.stringValueToPredicate(valueString, has, false));
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            collection.forEach(v -> predicates.add(this.stringValueToPredicate(v.toString(), has, true)));
            Map<String, List<HasContainer>> collect = predicates.stream().flatMap(p -> p.getPredicates().stream()).collect(Collectors.groupingBy(p -> p.getKey()));
            if (collect.size() == 0) {
                return PredicatesHolderFactory.abort();
            }
            predicates.clear();
            collect.forEach((key, hasContainers) -> {
                List values = hasContainers.stream().map(HasContainer::getValue).map(l -> ((Collection)l).iterator().next()).collect(Collectors.toList());
                predicates.add(PredicatesHolderFactory.predicate(new HasContainer(key, new P(has.getBiPredicate(), values))));
            });
        }
        return PredicatesHolderFactory.and(predicates);
    }

    public static class Builder
    implements PropertySchema.PropertySchemaBuilder {
        @Override
        public PropertySchema build(String key, Object conf, AbstractPropertyContainer container) {
            if (!(conf instanceof JSONObject)) {
                return null;
            }
            JSONObject config = (JSONObject)conf;
            Object obj = config.opt("fields");
            String delimiter = config.optString("delimiter", "_");
            if (obj == null || !(obj instanceof JSONArray)) {
                return null;
            }
            JSONArray fieldsArray = (JSONArray)obj;
            ArrayList<PropertySchema> schemas = new ArrayList<PropertySchema>();
            for (int i = 0; i < fieldsArray.length(); ++i) {
                Object field = fieldsArray.get(i);
                schemas.add(PropertySchemaFactory.createPropertySchema(key, field, container));
            }
            return new ConcatenateFieldPropertySchema(key, schemas, delimiter, config.optBoolean("nullable", true));
        }
    }
}

