/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.schema.property;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.AndP;
import org.apache.tinkerpop.gremlin.process.traversal.util.ConnectiveP;
import org.json.JSONArray;
import org.json.JSONObject;
import org.unipop.query.predicates.PredicatesHolder;
import org.unipop.query.predicates.PredicatesHolderFactory;
import org.unipop.schema.property.AbstractPropertyContainer;
import org.unipop.schema.property.DatePropertySchema;
import org.unipop.schema.property.FieldPropertySchema;
import org.unipop.schema.property.PropertySchema;
import org.unipop.util.ConversionUtils;
import org.unipop.util.MultiDateFormat;

public class DateFieldPropertySchema
extends FieldPropertySchema
implements DatePropertySchema {
    protected final String sourceFormat;
    protected final List<String> displayFormat;
    protected long interval;

    public DateFieldPropertySchema(String key, String field, String format, boolean nullable) {
        super(key, field, nullable);
        this.sourceFormat = format;
        this.displayFormat = Collections.singletonList("yyyy-MM-dd HH:mm:ss:SSS");
        this.interval = 86400000L;
    }

    public DateFieldPropertySchema(String key, JSONObject config, boolean nullable) {
        super(key, config, nullable);
        this.sourceFormat = config.optString("sourceFormat");
        JSONArray displayFormats = config.optJSONArray("displayFormats");
        if (displayFormats == null) {
            this.displayFormat = Collections.singletonList("yyyy-MM-dd HH:mm:ss:SSS");
        } else {
            List formats = ConversionUtils.asStream(displayFormats.iterator()).map(Object::toString).collect(Collectors.toList());
            this.displayFormat = formats;
        }
        String interval = config.optString("interval", "1d");
        if (interval.matches("\\d+")) {
            this.interval = Long.parseLong(interval);
        } else if (interval.endsWith("d")) {
            this.interval = Long.parseLong(interval.substring(0, interval.length() - 1)) * 1000L * 60L * 60L * 24L;
        } else if (interval.endsWith("h")) {
            this.interval = Long.parseLong(interval.substring(0, interval.length() - 1)) * 1000L * 60L * 60L;
        } else if (interval.endsWith("m")) {
            this.interval = Long.parseLong(interval.substring(0, interval.length() - 1)) * 1000L * 60L;
        } else if (interval.endsWith("s")) {
            this.interval = Long.parseLong(interval.substring(0, interval.length() - 1)) * 1000L;
        }
    }

    @Override
    public Set<Object> getValues(PredicatesHolder predicatesHolder) {
        Stream<PredicatesHolder> predicates = predicatesHolder.findKey(this.key).map(this::explodeConnective);
        HashMap datePredicates = new HashMap();
        predicates.flatMap(p -> p.getPredicates().stream()).forEach(has -> {
            String biPredicate = has.getBiPredicate().toString();
            Object value = has.getValue();
            switch (biPredicate) {
                case "eq": {
                    datePredicates.put("eq", this.fromDisplay(value.toString()));
                    break;
                }
                case "gt": {
                    datePredicates.put("gt", this.fromDisplay(value.toString()));
                }
                case "gte": {
                    datePredicates.put("gte", this.fromDisplay(value.toString()));
                    break;
                }
                case "lt": {
                    datePredicates.put("lt", this.fromDisplay(value.toString()));
                    break;
                }
                case "lte": {
                    datePredicates.put("lte", this.fromDisplay(value.toString()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("cant get value");
                }
            }
        });
        if (datePredicates.size() == 0) {
            return Collections.emptySet();
        }
        if (datePredicates.containsKey("eq")) {
            return Collections.singleton(this.toSource((Date)datePredicates.get("eq")));
        }
        if ((datePredicates.containsKey("gt") || datePredicates.containsKey("gte")) && (datePredicates.containsKey("lt") || datePredicates.containsKey("lte"))) {
            Date from = datePredicates.containsKey("gt") ? (Date)datePredicates.get("gt") : (Date)datePredicates.get("gte");
            Date to = datePredicates.containsKey("lt") ? (Date)datePredicates.get("lt") : (Date)datePredicates.get("lte");
            ArrayList<Date> dates = new ArrayList<Date>();
            long interval = this.interval;
            long endTime = to.getTime();
            for (long curTime = from.getTime(); curTime <= endTime; curTime += interval) {
                dates.add(new Date(curTime));
            }
            return dates.stream().map(this::toSource).collect(Collectors.toSet());
        }
        throw new IllegalArgumentException("cant get only gt or lt value");
    }

    public PredicatesHolder explodeConnective(HasContainer has) {
        if (has.getBiPredicate() instanceof ConnectiveP) {
            List predicates = ((ConnectiveP)has.getBiPredicate()).getPredicates();
            PredicatesHolder.Clause clause = has.getPredicate() instanceof AndP ? PredicatesHolder.Clause.And : PredicatesHolder.Clause.Or;
            Set<HasContainer> hasContainers = predicates.stream().map(p -> new HasContainer(has.getKey(), p)).collect(Collectors.toSet());
            return PredicatesHolderFactory.createFromPredicates(clause, hasContainers);
        }
        return PredicatesHolderFactory.predicate(has);
    }

    @Override
    public Map<String, Object> toProperties(Map<String, Object> source) {
        Object dateField = source.get(this.field);
        if (dateField == null || dateField.equals("")) {
            return Collections.emptyMap();
        }
        Date parsedDate = this.fromSource(dateField.toString());
        String displayDate = this.toDisplay(parsedDate);
        return Collections.singletonMap(this.key, displayDate);
    }

    @Override
    public Map<String, Object> toFields(Map<String, Object> properties) {
        Object dateProperty = properties.get(this.key);
        if (dateProperty == null) {
            return Collections.emptyMap();
        }
        Date parsedDate = this.fromDisplay(dateProperty.toString());
        String sourceDate = this.toSource(parsedDate);
        return Collections.singletonMap(this.field, sourceDate);
    }

    @Override
    public PredicatesHolder toPredicate(HasContainer has) {
        if (has.getPredicate() instanceof ConnectiveP) {
            List predicates = ((ConnectiveP)has.getPredicate()).getPredicates();
            predicates.forEach(p -> {
                Object dateValue = p.getValue();
                Date parsedDate = this.fromDisplay(dateValue.toString());
                String formattedDate = this.toSource(parsedDate);
                p.setValue((Object)formattedDate);
            });
            return PredicatesHolderFactory.predicate(new HasContainer(this.field, has.getPredicate()));
        }
        Object dateValue = has.getValue();
        Date parsedDate = this.fromDisplay(dateValue.toString());
        String formattedDate = this.toSource(parsedDate);
        P predicated = has.getPredicate().clone();
        predicated.setValue((Object)formattedDate);
        return PredicatesHolderFactory.predicate(new HasContainer(this.field, predicated));
    }

    @Override
    public DateFormat getSourceDateFormat() {
        return new SimpleDateFormat(this.sourceFormat);
    }

    @Override
    public DateFormat getDisplayDateFormat() {
        if (this.displayFormat.size() > 1) {
            return new MultiDateFormat(this.displayFormat.get(0), this.displayFormat.subList(1, this.displayFormat.size() - 1));
        }
        return new MultiDateFormat(this.displayFormat.get(0), Collections.emptyList());
    }

    public static class Builder
    implements PropertySchema.PropertySchemaBuilder {
        @Override
        public PropertySchema build(String key, Object conf, AbstractPropertyContainer container) {
            if (!(conf instanceof JSONObject)) {
                return null;
            }
            JSONObject config = (JSONObject)conf;
            Object field = config.opt("field");
            Object format = config.opt("sourceFormat");
            if (field == null || format == null) {
                return null;
            }
            return new DateFieldPropertySchema(key, config, config.optBoolean("nullable", true));
        }
    }
}

