/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.schema.property;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public interface DatePropertySchema {
    public DateFormat getSourceDateFormat();

    public DateFormat getDisplayDateFormat();

    default public Date fromSource(String date) {
        try {
            return this.getSourceDateFormat().parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("couldn't parse date:{0} using:{1}", date, this.getSourceDateFormat()));
        }
    }

    default public Date fromDisplay(String date) {
        try {
            return this.getDisplayDateFormat().parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("couldn't parse date:{0} using:{1}", date, this.getDisplayDateFormat()));
        }
    }

    default public String toDisplay(Date date) {
        return this.getDisplayDateFormat().format(date);
    }

    default public String toSource(Date date) {
        return this.getSourceDateFormat().format(date);
    }
}

