/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.schema.property;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.json.JSONObject;
import org.unipop.query.predicates.PredicatesHolder;
import org.unipop.query.predicates.PredicatesHolderFactory;
import org.unipop.schema.property.AbstractPropertyContainer;
import org.unipop.schema.property.PropertySchema;
import org.unipop.schema.property.type.PropertyType;
import org.unipop.util.ConversionUtils;
import org.unipop.util.PropertyTypeFactory;

public class FieldPropertySchema
implements PropertySchema {
    protected String key;
    protected String field = null;
    protected boolean nullable;
    protected Set include;
    protected Set exclude;
    protected PropertyType type;
    protected JSONObject alias;
    protected Map<String, String> reverseAlias;

    public FieldPropertySchema(String key, String field, boolean nullable) {
        this.key = key;
        this.field = field;
        this.nullable = nullable;
        try {
            this.type = PropertyTypeFactory.getType("STRING");
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        this.alias = null;
        this.reverseAlias = null;
    }

    public FieldPropertySchema(String key, JSONObject config, boolean nullable) {
        Object alias;
        this.key = key;
        this.nullable = nullable;
        this.field = config.getString("field");
        Set include = ConversionUtils.toSet(config, "include");
        this.include = include.isEmpty() ? null : include;
        Set exclude = ConversionUtils.toSet(config, "exclude");
        this.exclude = exclude.isEmpty() ? null : exclude;
        String typeName = config.optString("type", "STRING");
        try {
            this.type = PropertyTypeFactory.getType(typeName);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        if (include != null || exclude != null) {
            this.nullable = false;
        }
        JSONObject jSONObject = this.alias = (alias = config.opt("alias")) == null ? null : (JSONObject)alias;
        if (this.alias == null) {
            this.reverseAlias = null;
        } else {
            this.reverseAlias = new HashMap<String, String>();
            this.alias.keys().forEachRemaining(aliasKey -> this.reverseAlias.put(this.alias.getString(aliasKey), (String)aliasKey));
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Map<String, Object> toProperties(Map<String, Object> source) {
        Object value = source.get(this.field);
        if (value == null && this.nullable) {
            return Collections.emptyMap();
        }
        if (this.alias != null) {
            Object object = value = this.alias.has(value.toString()) ? this.alias.get(value.toString()) : value;
        }
        if (value == null || !this.test(P.eq((Object)value))) {
            return null;
        }
        return Collections.singletonMap(this.key, value);
    }

    @Override
    public Map<String, Object> toFields(Map<String, Object> properties) {
        Object value = properties.get(this.key);
        if (value == null && this.nullable) {
            return Collections.emptyMap();
        }
        if (value == null || !this.test(P.eq((Object)value))) {
            return null;
        }
        return Collections.singletonMap(this.field, value);
    }

    @Override
    public Set<String> toFields(Set<String> keys) {
        if (keys.contains(this.key) || !this.nullable) {
            return Collections.singleton(this.field);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Object> getValues(PredicatesHolder predicatesHolder) {
        Stream<HasContainer> predicates = predicatesHolder.findKey(this.key);
        Optional<Object> value = predicates.map(HasContainer::getValue).findFirst();
        return value.isPresent() ? Collections.singleton(value.get()) : null;
    }

    @Override
    public PredicatesHolder toPredicate(HasContainer has) {
        P predicate;
        if (has != null && !this.test(has.getPredicate())) {
            return PredicatesHolderFactory.abort();
        }
        if (has != null) {
            Object predicateValue;
            predicate = has.getPredicate().clone();
            if (this.reverseAlias != null && this.reverseAlias.containsKey((predicateValue = predicate.getValue()).toString())) {
                predicate.setValue((Object)this.reverseAlias.get(predicateValue.toString()));
            }
        } else if (this.include != null) {
            predicate = P.within((Collection)this.include);
        } else if (this.exclude != null) {
            predicate = P.without((Collection)this.exclude);
        } else {
            return PredicatesHolderFactory.empty();
        }
        P translatedPredicate = this.type.translate(predicate);
        HasContainer hasContainer = new HasContainer(this.field, translatedPredicate);
        return PredicatesHolderFactory.predicate(hasContainer);
    }

    @Override
    public Set<String> excludeDynamicFields() {
        return Collections.singleton(this.field);
    }

    @Override
    public Set<String> excludeDynamicProperties() {
        return Collections.singleton(this.key);
    }

    protected boolean test(P predicate) {
        if (this.include != null) {
            for (Object include : this.include) {
                if (!predicate.test(include)) continue;
                return true;
            }
            return false;
        }
        if (predicate.getBiPredicate() instanceof Contains) {
            return true;
        }
        if (this.exclude != null) {
            for (Object exclude : this.exclude) {
                if (!predicate.test(exclude)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public String toString() {
        return "FieldPropertySchema{exclude=" + this.exclude + ", key='" + this.key + '\'' + ", field='" + this.field + '\'' + ", nullable=" + this.nullable + ", include=" + this.include + '}';
    }

    public static class Builder
    implements PropertySchema.PropertySchemaBuilder {
        @Override
        public PropertySchema build(String key, Object conf, AbstractPropertyContainer container) {
            boolean nullable;
            boolean bl = nullable = !key.equals("~id") && !key.equals("~label");
            if (conf instanceof String) {
                String field = conf.toString();
                if (!field.startsWith("@")) {
                    return null;
                }
                return new FieldPropertySchema(key, field.substring(1), nullable);
            }
            if (!(conf instanceof JSONObject)) {
                return null;
            }
            JSONObject config = (JSONObject)conf;
            Object field = config.opt("field");
            if (field == null) {
                return null;
            }
            return new FieldPropertySchema(key, config, config.optBoolean("nullable", nullable));
        }
    }
}

