/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.schema.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.json.JSONArray;
import org.unipop.query.predicates.PredicatesHolder;
import org.unipop.query.predicates.PredicatesHolderFactory;
import org.unipop.schema.property.AbstractPropertyContainer;
import org.unipop.schema.property.ParentSchemaProperty;
import org.unipop.schema.property.PropertySchema;
import org.unipop.util.PropertySchemaFactory;

public class MultiPropertySchema
implements ParentSchemaProperty {
    private String key;
    private List<PropertySchema> schemas;

    public MultiPropertySchema(String key, List<PropertySchema> schemas) {
        this.key = key;
        this.schemas = schemas;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Map<String, Object> toProperties(Map<String, Object> source) {
        ArrayList value = new ArrayList();
        this.schemas.forEach(schema -> schema.toProperties(source).values().forEach(value::add));
        return Collections.singletonMap(this.key, value);
    }

    @Override
    public Collection<PropertySchema> getChildren() {
        return this.schemas;
    }

    @Override
    public Set<String> excludeDynamicFields() {
        return this.schemas.stream().map(PropertySchema::excludeDynamicFields).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Set<String> excludeDynamicProperties() {
        return Collections.singleton(this.key);
    }

    @Override
    public Map<String, Object> toFields(Map<String, Object> properties) {
        return Collections.emptyMap();
    }

    @Override
    public Set<String> toFields(Set<String> propertyKeys) {
        return this.schemas.stream().flatMap(s -> s.toFields(propertyKeys).stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<Object> getValues(PredicatesHolder predicatesHolder) {
        return this.schemas.stream().map(schema -> schema.getValues(predicatesHolder)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public PredicatesHolder toPredicate(HasContainer hasContainer) {
        HashSet<PredicatesHolder> predicates = new HashSet<PredicatesHolder>();
        for (PropertySchema schema : this.schemas) {
            PredicatesHolder predicatesHolder = schema.toPredicates(PredicatesHolderFactory.predicate(hasContainer));
            if (predicatesHolder.equals(PredicatesHolderFactory.empty())) {
                return predicatesHolder;
            }
            if (predicatesHolder.equals(PredicatesHolderFactory.abort())) continue;
            predicates.add(predicatesHolder);
        }
        return PredicatesHolderFactory.or(predicates);
    }

    public static class Builder
    implements PropertySchema.PropertySchemaBuilder {
        @Override
        public PropertySchema build(String key, Object conf, AbstractPropertyContainer container) {
            if (!(conf instanceof JSONArray)) {
                return null;
            }
            JSONArray fieldsArray = (JSONArray)conf;
            ArrayList<PropertySchema> schemas = new ArrayList<PropertySchema>();
            for (int i = 0; i < fieldsArray.length(); ++i) {
                schemas.add(PropertySchemaFactory.createPropertySchema(key, fieldsArray.get(i), container));
            }
            return new MultiPropertySchema(key, schemas);
        }
    }
}

