/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.schema.property;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.unipop.query.predicates.PredicatesHolder;
import org.unipop.query.predicates.PredicatesHolderFactory;
import org.unipop.schema.property.AbstractPropertyContainer;
import org.unipop.schema.property.PropertySchema;

public class StaticPropertySchema
implements PropertySchema {
    protected final String key;
    protected final String value;

    public StaticPropertySchema(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Map<String, Object> toProperties(Map<String, Object> source) {
        return Collections.singletonMap(this.key, this.value);
    }

    @Override
    public Map<String, Object> toFields(Map<String, Object> prop) {
        Object o = prop.get(this.key);
        if (o == null || o.equals(this.value)) {
            return Collections.emptyMap();
        }
        return null;
    }

    @Override
    public Set<String> toFields(Set<String> propertyKeys) {
        return Collections.emptySet();
    }

    @Override
    public Set<Object> getValues(PredicatesHolder predicatesHolder) {
        return Collections.singleton(this.value);
    }

    @Override
    public PredicatesHolder toPredicates(PredicatesHolder predicatesHolder) {
        Set<PredicatesHolder> predicates = predicatesHolder.findKey(this.key).map(has -> {
            if (has != null && !this.test(has.getPredicate())) {
                return PredicatesHolderFactory.abort();
            }
            return PredicatesHolderFactory.empty();
        }).collect(Collectors.toSet());
        return PredicatesHolderFactory.create(predicatesHolder.getClause(), predicates);
    }

    @Override
    public Set<String> excludeDynamicProperties() {
        return Collections.singleton(this.key);
    }

    protected boolean test(P predicate) {
        return predicate.test((Object)this.value);
    }

    public String toString() {
        return "StaticPropertySchema{key='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public static class Builder
    implements PropertySchema.PropertySchemaBuilder {
        @Override
        public PropertySchema build(String key, Object conf, AbstractPropertyContainer container) {
            if (!(conf instanceof String)) {
                return null;
            }
            String value = conf.toString();
            if (value.startsWith("@")) {
                return null;
            }
            return new StaticPropertySchema(key, value);
        }
    }
}

