/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.schema.property.type;

import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.unipop.process.predicate.Date;
import org.unipop.schema.property.type.PropertyType;

public class DateType
implements PropertyType {
    @Override
    public String getType() {
        return "DATE";
    }

    @Override
    public <V> P<V> translate(P<V> predicate) {
        BiPredicate biPredicate = predicate.getBiPredicate();
        if (biPredicate instanceof Compare) {
            String predicateString = biPredicate.toString();
            Object value = predicate.getValue();
            switch (predicateString) {
                case "eq": {
                    return Date.eq(value);
                }
                case "neq": {
                    return Date.neq(value);
                }
                case "lt": {
                    return Date.lt(value);
                }
                case "gt": {
                    return Date.gt(value);
                }
                case "lte": {
                    return Date.lte(value);
                }
                case "gte": {
                    return Date.gte(value);
                }
            }
            throw new IllegalArgumentException("cant convert '" + predicateString + "' to DatePredicate");
        }
        throw new IllegalArgumentException("cant convert '" + biPredicate.toString() + "' to DatePredicate");
    }
}

