/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.structure;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.unipop.query.mutation.PropertyQuery;
import org.unipop.structure.UniElement;
import org.unipop.structure.UniGraph;
import org.unipop.structure.UniProperty;

public class UniEdge
extends UniElement
implements Edge {
    protected Map<String, Property> properties;
    protected Vertex inVertex;
    protected Vertex outVertex;

    public UniEdge(Map<String, Object> keyValues, Vertex outV, Vertex inV, UniGraph graph) {
        super(keyValues, graph);
        this.outVertex = outV;
        this.inVertex = inV;
        this.properties = new HashMap<String, Property>();
        keyValues.forEach(this::addPropertyLocal);
    }

    @Override
    protected Map<String, Property> getPropertiesMap() {
        return this.properties;
    }

    @Override
    protected String getDefaultLabel() {
        return "edge";
    }

    @Override
    protected Property createProperty(String key, Object value) {
        return new UniProperty<Object>(this, key, value);
    }

    public <V> Property<V> property(String key, V value) {
        UniProperty vertexProperty = (UniProperty)this.addPropertyLocal(key, value);
        PropertyQuery<UniEdge> propertyQuery = new PropertyQuery<UniEdge>(this, vertexProperty, PropertyQuery.Action.Add, null);
        this.graph.getControllerManager().getControllers(PropertyQuery.PropertyController.class).forEach(controller -> controller.property(propertyQuery));
        return vertexProperty;
    }

    public Iterator<Vertex> vertices(Direction direction) {
        if (direction.equals((Object)Direction.OUT)) {
            return IteratorUtils.singletonIterator((Object)this.outVertex);
        }
        if (direction.equals((Object)Direction.IN)) {
            return IteratorUtils.singletonIterator((Object)this.inVertex);
        }
        return Arrays.asList(this.outVertex, this.inVertex).iterator();
    }

    public Iterator<Property> properties(String ... propertyKeys) {
        return this.propertyIterator(propertyKeys);
    }

    @Override
    public String toString() {
        return StringFactory.edgeString((Edge)this);
    }
}

