/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.structure;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.unipop.query.mutation.PropertyQuery;
import org.unipop.query.mutation.RemoveQuery;
import org.unipop.structure.UniGraph;

public abstract class UniElement
implements Element {
    protected String id;
    protected String label;
    protected UniGraph graph;

    public UniElement(Map<String, Object> properties, UniGraph graph) {
        this.graph = graph;
        this.id = ObjectUtils.firstNonNull((Object[])new Object[]{properties.remove(T.id.getAccessor()), properties.remove(T.id.toString()), UUID.randomUUID()}).toString();
        this.label = ObjectUtils.firstNonNull((Object[])new Object[]{properties.remove(T.label.getAccessor()), properties.remove(T.label.toString()), this.getDefaultLabel()}).toString();
    }

    protected abstract Map<String, Property> getPropertiesMap();

    protected abstract String getDefaultLabel();

    protected Property addPropertyLocal(String key, Object value) {
        ElementHelper.validateProperty((String)key, (Object)value);
        Property property = this.createProperty(key, value);
        this.getPropertiesMap().put(key, property);
        return property;
    }

    public Object id() {
        return this.id;
    }

    public String label() {
        return this.label;
    }

    public Graph graph() {
        return this.graph;
    }

    public Set<String> keys() {
        return this.getPropertiesMap().keySet();
    }

    public <V> Property<V> property(String key) {
        return this.getPropertiesMap().containsKey(key) ? this.getPropertiesMap().get(key) : Property.empty();
    }

    public int hashCode() {
        return ElementHelper.hashCode((Element)this);
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual((Element)this, (Object)object);
    }

    protected Iterator propertyIterator(String[] propertyKeys) {
        Map<String, Property> properties = this.getPropertiesMap();
        if (propertyKeys.length > 0) {
            return properties.entrySet().stream().filter(entry -> ElementHelper.keyExists((String)((String)entry.getKey()), (String[])propertyKeys)).map(x -> (Property)x.getValue()).iterator();
        }
        return properties.values().iterator();
    }

    public void removeProperty(Property property) {
        this.getPropertiesMap().remove(property.key());
        PropertyQuery<UniElement> propertyQuery = new PropertyQuery<UniElement>(this, property, PropertyQuery.Action.Remove, null);
        this.graph.getControllerManager().getControllers(PropertyQuery.PropertyController.class).forEach(controller -> controller.property(propertyQuery));
    }

    protected abstract Property createProperty(String var1, Object var2);

    public void remove() {
        RemoveQuery<UniElement> removeQuery = new RemoveQuery<UniElement>(Arrays.asList(this), null);
        this.graph.getControllerManager().getControllers(RemoveQuery.RemoveController.class).forEach(controller -> controller.remove(removeQuery));
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public UniGraph getGraph() {
        return this.graph;
    }

    public static <E extends Element> Map<String, Object> fullProperties(E element) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(T.id.getAccessor(), element.id());
        properties.put(T.label.getAccessor(), element.label());
        element.properties(new String[0]).forEachRemaining(property -> properties.put(property.key(), property.value()));
        return properties;
    }

    public String toString() {
        return "UniElement{properties=" + this.getPropertiesMap() + ", id='" + this.id + '\'' + ", label='" + this.label + '\'' + ", graph=" + this.graph + '}';
    }
}

