/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.NotImplementedException;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.unipop.query.mutation.AddEdgeQuery;
import org.unipop.query.mutation.PropertyQuery;
import org.unipop.query.predicates.PredicatesHolder;
import org.unipop.query.predicates.PredicatesHolderFactory;
import org.unipop.query.search.SearchVertexQuery;
import org.unipop.structure.UniElement;
import org.unipop.structure.UniGraph;
import org.unipop.structure.UniVertexProperty;
import org.unipop.util.ConversionUtils;

public class UniVertex
extends UniElement
implements Vertex {
    protected Map<String, List<VertexProperty>> properties = new ConcurrentHashMap<String, List<VertexProperty>>();

    public UniVertex(Map<String, Object> keyValues, UniGraph graph) {
        super(keyValues, graph);
        keyValues.forEach((key, value) -> {
            List<UniVertexProperty<Object>> props;
            if (value instanceof Collection) {
                props = ((Collection)value).stream().map(v -> new UniVertexProperty<Object>(this, (String)key, v)).collect(Collectors.toList());
            } else {
                props = new ArrayList<UniVertexProperty<Object>>();
                props.add(new UniVertexProperty<Object>(this, (String)key, value));
            }
            this.properties.put((String)key, (List<VertexProperty>)props);
        });
    }

    @Override
    public Set<String> keys() {
        return this.properties.keySet();
    }

    @Override
    protected Map<String, Property> getPropertiesMap() {
        throw new NotImplementedException();
    }

    @Override
    public void removeProperty(Property property) {
        List<VertexProperty> props = this.properties.get(property.key());
        props.remove(props.indexOf(property));
        if (props.size() == 0) {
            this.properties.remove(property.key());
        }
        PropertyQuery<UniVertex> propertyQuery = new PropertyQuery<UniVertex>(this, property, PropertyQuery.Action.Remove, null);
        this.graph.getControllerManager().getControllers(PropertyQuery.PropertyController.class).forEach(controller -> controller.property(propertyQuery));
    }

    @Override
    protected String getDefaultLabel() {
        return "vertex";
    }

    @Override
    protected Property createProperty(String key, Object value) {
        return new UniVertexProperty<Object>(this, key, value);
    }

    @Override
    protected Property addPropertyLocal(String key, Object value) {
        ElementHelper.validateProperty((String)key, (Object)value);
        UniVertexProperty property = (UniVertexProperty)this.createProperty(key, value);
        ArrayList<UniVertexProperty> props = this.properties.containsKey(key) ? this.properties.get(key) : new ArrayList<UniVertexProperty>();
        props.add(property);
        if (props.size() == 1) {
            this.properties.put(key, props);
        }
        return property;
    }

    public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        if (keyValues != null && keyValues.length > 0) {
            throw VertexProperty.Exceptions.metaPropertiesNotSupported();
        }
        if (cardinality.equals((Object)VertexProperty.Cardinality.single)) {
            this.properties.remove(key);
        }
        return this.property(key, value);
    }

    public Iterator<Edge> edges(Direction direction, String ... edgeLabels) {
        PredicatesHolder predicatesHolder = edgeLabels.length == 0 ? PredicatesHolderFactory.empty() : PredicatesHolderFactory.predicate(new HasContainer(T.label.getAccessor(), P.within((Object[])edgeLabels)));
        SearchVertexQuery searchVertexQuery = new SearchVertexQuery(Edge.class, Arrays.asList(this), direction, predicatesHolder, -1, null, null, null);
        return this.graph.getControllerManager().getControllers(SearchVertexQuery.SearchVertexController.class).stream().map(controller -> controller.search(searchVertexQuery)).flatMap(ConversionUtils::asStream).iterator();
    }

    public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
        Iterator<Edge> edges = this.edges(direction, edgeLabels);
        return ConversionUtils.asStream(edges).map(edge -> UniVertex.vertexToVertex(this, edge, direction)).iterator();
    }

    public static Vertex vertexToVertex(Vertex source, Edge edge, Direction direction) {
        switch (direction) {
            case OUT: {
                return edge.inVertex();
            }
            case IN: {
                return edge.outVertex();
            }
            case BOTH: {
                Vertex outV = edge.outVertex();
                Vertex inV = edge.inVertex();
                if (outV.id().equals(inV.id())) {
                    return outV;
                }
                if (source.id().equals(inV.id())) {
                    return outV;
                }
                if (!source.id().equals(outV.id())) break;
                return inV;
            }
        }
        throw new IllegalArgumentException(direction.toString());
    }

    public <V> VertexProperty<V> property(String key, V value) {
        UniVertexProperty vertexProperty = (UniVertexProperty)this.addPropertyLocal(key, value);
        PropertyQuery<UniVertex> propertyQuery = new PropertyQuery<UniVertex>(this, (Property)vertexProperty, PropertyQuery.Action.Add, null);
        this.graph.getControllerManager().getControllers(PropertyQuery.PropertyController.class).forEach(controller -> controller.property(propertyQuery));
        return vertexProperty;
    }

    public <V> VertexProperty<V> property(String key) {
        if (this.properties.containsKey(key)) {
            return this.properties.get(key).get(0);
        }
        return VertexProperty.empty();
    }

    public Edge addEdge(String label, Vertex vertex, Object ... keyValues) {
        if (null == vertex) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"vertex");
        }
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        ElementHelper.validateLabel((String)label);
        Map<String, Object> stringObjectMap = ConversionUtils.asMap(keyValues);
        stringObjectMap.put(T.label.toString(), label);
        return this.graph.getControllerManager().getControllers(AddEdgeQuery.AddEdgeController.class).stream().map(controller -> controller.addEdge(new AddEdgeQuery(this, vertex, new HashMap<String, Object>(stringObjectMap), null))).filter(e -> e != null).findFirst().get();
    }

    @Override
    public void remove() {
        this.edges(Direction.BOTH, new String[0]).forEachRemaining(Element::remove);
        super.remove();
    }

    @Override
    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
        if (propertyKeys.length == 0) {
            return this.properties.values().stream().flatMap(l -> l.stream()).map(p -> p).iterator();
        }
        List<String> keys = Arrays.asList(propertyKeys);
        return this.properties.values().stream().flatMap(l -> l.stream()).map(p -> p).filter(v -> keys.contains(v.key())).iterator();
    }
}

