/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.test;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.AbstractGraphProvider;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.unipop.structure.UniEdge;
import org.unipop.structure.UniElement;
import org.unipop.structure.UniGraph;
import org.unipop.structure.UniProperty;
import org.unipop.structure.UniVertex;
import org.unipop.structure.UniVertexProperty;

public abstract class UnipopGraphProvider
extends AbstractGraphProvider {
    private static final Set<Class> IMPLEMENTATION = new HashSet<Class>(){
        {
            this.add(UniGraph.class);
            this.add(UniElement.class);
            this.add(UniVertex.class);
            this.add(UniEdge.class);
            this.add(UniProperty.class);
            this.add(UniVertexProperty.class);
        }
    };

    public Map<String, Object> getBaseConfiguration(final String graphName, Class<?> test, String testMethodName, LoadGraphWith.GraphData loadGraphWith) {
        return new HashMap<String, Object>(){
            {
                this.put("gremlin.graph", UniGraph.class.getName());
                this.put("graphName", graphName.toLowerCase());
            }
        };
    }

    public void clear(Graph g, Configuration configuration) throws Exception {
        if (g != null) {
            g.close();
        }
    }

    public Set<Class> getImplementations() {
        return IMPLEMENTATION;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface OptIn {
        public static final String UnipopStructureSuite = "org.unipop.test.UnipopStructureSuite";
        public static final String UnipopProcessSuite = "org.unipop.test.UnipopProcessSuite";

        public String value();
    }
}

