/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.json.JSONArray;
import org.json.JSONObject;

public class ConversionUtils {
    public static <T> Stream<T> asStream(Iterator<T> sourceIterator) {
        return ConversionUtils.asStream(sourceIterator, false);
    }

    public static <T> Stream<T> asStream(Iterator<T> sourceIterator, boolean parallel) {
        Iterable iterable = () -> sourceIterator;
        return StreamSupport.stream(iterable.spliterator(), parallel);
    }

    public static <T> Set<T> toSet(JSONObject config, String key) {
        JSONArray objects = config.optJSONArray(key);
        if (objects != null) {
            HashSet<Object> hashSet = new HashSet<Object>(objects.length());
            for (int i = 0; i < objects.length(); ++i) {
                hashSet.add(objects.get(i));
            }
            return hashSet;
        }
        Object opt = config.opt(key);
        if (opt != null) {
            return Collections.singleton(opt);
        }
        return Collections.EMPTY_SET;
    }

    public static Map<String, Object> asMap(Object[] keyValues) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (keyValues != null) {
            ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
            for (int i = 0; i < keyValues.length; i += 2) {
                String key = keyValues[i].toString();
                Object value = keyValues[i + 1];
                ElementHelper.validateProperty((String)key, (Object)value);
                if (map.containsKey(key)) {
                    final Object o = map.get(key);
                    List<Object> list = o instanceof List ? (List<Object>)o : new ArrayList<Object>(){
                        {
                            this.add(o);
                        }
                    };
                    list.add(value);
                    value = list;
                }
                map.put(key, value);
            }
        }
        return map;
    }

    public static List<JSONObject> getList(JSONObject json, String key) {
        JSONArray objectsArray = json.optJSONArray(key);
        if (objectsArray == null) {
            return Collections.emptyList();
        }
        ArrayList<JSONObject> objects = new ArrayList<JSONObject>();
        for (int i = 0; i < objectsArray.length(); ++i) {
            JSONObject config = objectsArray.getJSONObject(i);
            objects.add(config);
        }
        return objects;
    }

    public static List<String> toStringList(JSONObject config, String key) {
        JSONArray addressesConfiguration = config.optJSONArray(key);
        if (addressesConfiguration != null) {
            ArrayList<String> addresses = new ArrayList<String>();
            for (int i = 0; i < addressesConfiguration.length(); ++i) {
                String address = addressesConfiguration.getString(i);
                addresses.add(address);
            }
            return addresses;
        }
        return Collections.singletonList(config.getString(key));
    }

    public static <K, V> Map<K, V> merge(List<Map<K, V>> maps, BiFunction<? super V, ? super V, ? extends V> mergeFunc, Boolean ignoreNull) {
        HashMap newMap = new HashMap(maps.size());
        for (Map<Object, Object> map : maps) {
            if (map == null) {
                if (ignoreNull.booleanValue()) continue;
                return null;
            }
            map.forEach((fieldKey, fieldValue) -> newMap.merge(fieldKey, fieldValue, mergeFunc));
        }
        return newMap;
    }
}

