/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.util;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Timer;
import java.util.TimerTask;

public class DirectoryWatcher {
    private WatchService service;
    private OnFileChange onFileChange;
    private Timer timer;
    private TimerTask timerTask;
    private int interval;

    public DirectoryWatcher(Path path, int interval, OnFileChange onFileChange) {
        this.watchDirectoryPath(path);
        this.onFileChange = onFileChange;
        this.timer = new Timer();
        this.interval = interval;
    }

    public void start() {
        this.timer.scheduleAtFixedRate(this.timerTask, 0L, (long)this.interval);
    }

    public void stop() throws IOException {
        this.timer.cancel();
        if (this.service != null) {
            this.service.close();
        }
    }

    private void watchDirectoryPath(Path path) {
        try {
            Boolean isFolder = (Boolean)Files.getAttribute(path, "basic:isDirectory", LinkOption.NOFOLLOW_LINKS);
            if (!isFolder.booleanValue()) {
                throw new IllegalArgumentException("Path: " + path + " is not a folder");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        FileSystem fs = path.getFileSystem();
        try {
            this.service = fs.newWatchService();
            path.register(this.service, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    WatchKey key = null;
                    try {
                        key = DirectoryWatcher.this.service.take();
                        WatchEvent.Kind<?> kind = null;
                        for (WatchEvent<?> watchEvent : key.pollEvents()) {
                            Path newPath;
                            kind = watchEvent.kind();
                            if (StandardWatchEventKinds.OVERFLOW == kind || StandardWatchEventKinds.ENTRY_CREATE != kind && StandardWatchEventKinds.ENTRY_MODIFY != kind && StandardWatchEventKinds.ENTRY_DELETE != kind || !DirectoryWatcher.notSwap(newPath = (Path)watchEvent.context())) continue;
                            DirectoryWatcher.this.onFileChange.onFileChange(newPath);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean notSwap(Path file) {
        return !file.toString().endsWith(".swp") && !file.toString().endsWith(".swpx") && !file.toString().endsWith("~");
    }

    @FunctionalInterface
    public static interface OnFileChange {
        public void onFileChange(Path var1) throws IOException;
    }
}

