/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.util;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.unipop.query.UniQuery;
import org.unipop.query.controller.SimpleController;
import org.unipop.schema.element.ElementSchema;

public class MetricsRunner {
    private Optional<MutableMetrics> metrics;
    private MutableMetrics controllerMetrics;

    public MetricsRunner(SimpleController controller, UniQuery query, Collection<ElementSchema> schemas) {
        if (query.getStepDescriptor() != null) {
            this.metrics = query.getStepDescriptor().getMetrics();
            this.controllerMetrics = new MutableMetrics(query.getStepDescriptor().getId() + controller.toString(), controller.toString());
        } else {
            this.metrics = Optional.empty();
            this.controllerMetrics = new MutableMetrics(controller.toString(), controller.toString());
        }
        this.metrics.ifPresent(metric -> metric.addNested(this.controllerMetrics));
        this.controllerMetrics.start();
        List<MutableMetrics> childMetrics = schemas.stream().map(schema -> new MutableMetrics(this.controllerMetrics.getId() + schema.toString(), schema.toString())).collect(Collectors.toList());
        childMetrics.forEach(arg_0 -> ((MutableMetrics)this.controllerMetrics).addNested(arg_0));
    }

    public void stop(FillChildren fillChildren) {
        this.controllerMetrics.stop();
        if (this.metrics.isPresent()) {
            fillChildren.fillChildren(this.controllerMetrics.getNested().stream().map(m -> (MutableMetrics)m).collect(Collectors.toList()));
            this.controllerMetrics.setCount("elementCount", this.controllerMetrics.getNested().stream().mapToLong(n -> n.getCount("elementCount")).sum());
        }
    }

    @FunctionalInterface
    public static interface FillChildren {
        public void fillChildren(List<MutableMetrics> var1);
    }
}

