/*
 * Decompiled with CFR 0.152.
 */
package org.unipop.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.unipop.schema.property.type.PropertyType;

public class PropertyTypeFactory {
    private static Set<PropertyType> propertyTypes;

    public static void init(List<String> types) {
        propertyTypes = new HashSet<PropertyType>();
        for (String type : types) {
            try {
                PropertyType propertyType = Class.forName(type).asSubclass(PropertyType.class).newInstance();
                propertyTypes.add(propertyType);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("class: '" + type + "' not found");
            }
        }
    }

    public static PropertyType getType(String typeName) throws IllegalAccessException, InstantiationException {
        for (PropertyType propertyType : propertyTypes) {
            if (!propertyType.getType().equals(typeName.toUpperCase())) continue;
            return propertyType;
        }
        throw new IllegalArgumentException("Property type: '" + typeName + "' does not exists");
    }
}

