/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.collection.primitive;

import java.util.Collection;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;

/**
 * This file was automatically generated from template file mutablePrimitiveCollection.stg.
 *
 * @since 3.0.
 */
public interface MutableCharCollection extends CharIterable
{
    boolean add(char element);

    boolean addAll(char... source);

    boolean addAll(CharIterable source);

    boolean remove(char value);

    boolean removeAll(CharIterable source);

    boolean removeAll(char... source);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(CharIterable elements);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(char... source);

    void clear();

    MutableCharCollection select(CharPredicate predicate);

    MutableCharCollection reject(CharPredicate predicate);

    <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function);

    MutableCharCollection with(char element);

    MutableCharCollection without(char element);

    MutableCharCollection withAll(CharIterable elements);

    MutableCharCollection withoutAll(CharIterable elements);

    MutableCharCollection asUnmodifiable();

    MutableCharCollection asSynchronized();

    ImmutableCharCollection toImmutable();
}
