/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.collection.primitive;

import java.util.Collection;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;

/**
 * This file was automatically generated from template file mutablePrimitiveCollection.stg.
 *
 * @since 3.0.
 */
public interface MutableLongCollection extends LongIterable
{
    boolean add(long element);

    boolean addAll(long... source);

    boolean addAll(LongIterable source);

    boolean remove(long value);

    boolean removeAll(LongIterable source);

    boolean removeAll(long... source);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(LongIterable elements);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(long... source);

    void clear();

    MutableLongCollection select(LongPredicate predicate);

    MutableLongCollection reject(LongPredicate predicate);

    <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function);

    MutableLongCollection with(long element);

    MutableLongCollection without(long element);

    MutableLongCollection withAll(LongIterable elements);

    MutableLongCollection withoutAll(LongIterable elements);

    MutableLongCollection asUnmodifiable();

    MutableLongCollection asSynchronized();

    ImmutableLongCollection toImmutable();
}
