/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.ImmutableByteObjectMap;
import com.gs.collections.api.map.primitive.ByteObjectMap;

/**
 * A factory which creates instances of type {@link ImmutableByteObjectMap}.
 * This file was automatically generated from template file immutablePrimitiveObjectMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableByteObjectMapFactory
{
    /**
     * Same as {@link #with()}.
     */
    <V> ImmutableByteObjectMap<V> of();

    <V> ImmutableByteObjectMap<V> with();

    /**
     * Same as {@link #with(byte, Object)}.
     */
    <V> ImmutableByteObjectMap<V> of(byte key, V value);

    <V> ImmutableByteObjectMap<V> with(byte key, V value);

    /**
     * Same as {@link #withAll(ByteObjectMap)}.
     */
    <V> ImmutableByteObjectMap<V> ofAll(ByteObjectMap<? extends V>  map);

    <V> ImmutableByteObjectMap<V> withAll(ByteObjectMap<? extends V>  map);
}
