/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.ImmutableDoubleLongMap;
import com.gs.collections.api.map.primitive.DoubleLongMap;

/**
 * A factory which creates instances of type {@link ImmutableDoubleLongMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableDoubleLongMapFactory
{
    /**
     * Same as {@link #with()}.
     */
    ImmutableDoubleLongMap of();

    ImmutableDoubleLongMap with();

    /**
     * Same as {@link #with(double, long)}.
     */
    ImmutableDoubleLongMap of(double key, long value);

    ImmutableDoubleLongMap with(double key, long value);

    /**
     * Same as {@link #withAll(DoubleLongMap)}.
     */
    ImmutableDoubleLongMap ofAll(DoubleLongMap map);

    ImmutableDoubleLongMap withAll(DoubleLongMap map);
}
