/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.ImmutableObjectFloatMap;
import com.gs.collections.api.map.primitive.ObjectFloatMap;

/**
 * A factory which creates instances of type {@link ImmutableObjectFloatMap}.
 * This file was automatically generated from template file immutableObjectPrimitiveMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableObjectFloatMapFactory
{
    /**
     * Same as {@link #with()}.
     */
    <K> ImmutableObjectFloatMap<K> of();

    <K> ImmutableObjectFloatMap<K> with();

    /**
     * Same as {@link #with(Object, float)}.
     */
    <K> ImmutableObjectFloatMap<K> of(K key, float value);

    <K> ImmutableObjectFloatMap<K> with(K key, float value);

    /**
     * Same as {@link #withAll(ObjectFloatMap)}.
     */
    <K> ImmutableObjectFloatMap<K> ofAll(ObjectFloatMap<? extends K>  map);

    <K> ImmutableObjectFloatMap<K> withAll(ObjectFloatMap<? extends K>  map);
}
